/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap.internal;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.log.LogUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.ldap.LDAPSettings;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.ldap.authenticator.configuration.LDAPAuthConfiguration;
import com.liferay.portal.security.ldap.configuration.ConfigurationProvider;
import com.liferay.portal.security.ldap.configuration.LDAPServerConfiguration;
import com.liferay.portal.security.ldap.configuration.SystemLDAPConfiguration;
import com.liferay.portal.security.ldap.exportimport.configuration.LDAPExportConfiguration;
import com.liferay.portal.security.ldap.exportimport.configuration.LDAPImportConfiguration;
import com.liferay.portal.security.ldap.validator.LDAPFilterValidator;
import java.util.Properties;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={LDAPSettings.class})
public class DefaultLDAPSettings
implements LDAPSettings {
    private static final Log _log = LogFactoryUtil.getLog(DefaultLDAPSettings.class);
    private ConfigurationProvider<LDAPAuthConfiguration> _ldapAuthConfigurationProvider;
    private ConfigurationProvider<LDAPExportConfiguration> _ldapExportConfigurationProvider;
    @Reference
    private LDAPFilterValidator _ldapFilterValidator;
    private ConfigurationProvider<LDAPImportConfiguration> _ldapImportConfigurationProvider;
    private ConfigurationProvider<LDAPServerConfiguration> _ldapServerConfigurationProvider;
    private ConfigurationProvider<SystemLDAPConfiguration> _systemLDAPConfigurationProvider;
    private UserLocalService _userLocalService;

    public String getAuthSearchFilter(long ldapServerId, long companyId, String emailAddress, String screenName, String userId) throws Exception {
        LDAPServerConfiguration ldapServerConfiguration = (LDAPServerConfiguration)this._ldapServerConfigurationProvider.getConfiguration(companyId, ldapServerId);
        String filter = ldapServerConfiguration.authSearchFilter();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Search filter before transformation " + filter));
        }
        filter = StringUtil.replace((String)filter, (String[])new String[]{"@company_id@", "@email_address@", "@screen_name@", "@user_id@"}, (String[])new String[]{String.valueOf(companyId), emailAddress, screenName, userId});
        this._ldapFilterValidator.validate(filter);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Search filter after transformation " + filter));
        }
        return filter;
    }

    public Properties getContactExpandoMappings(long ldapServerId, long companyId) throws Exception {
        LDAPServerConfiguration ldapServerConfiguration = (LDAPServerConfiguration)this._ldapServerConfigurationProvider.getConfiguration(companyId, ldapServerId);
        Properties contactExpandoMappings = this.getProperties(ldapServerConfiguration.contactCustomMappings());
        LogUtil.debug((Log)_log, (Properties)contactExpandoMappings);
        return contactExpandoMappings;
    }

    public Properties getContactMappings(long ldapServerId, long companyId) throws Exception {
        LDAPServerConfiguration ldapServerConfiguration = (LDAPServerConfiguration)this._ldapServerConfigurationProvider.getConfiguration(companyId, ldapServerId);
        Properties contactMappings = this.getProperties(ldapServerConfiguration.contactMappings());
        LogUtil.debug((Log)_log, (Properties)contactMappings);
        return contactMappings;
    }

    public String[] getErrorPasswordHistoryKeywords(long companyId) {
        SystemLDAPConfiguration systemLDAPConfiguration = (SystemLDAPConfiguration)this._systemLDAPConfigurationProvider.getConfiguration(companyId);
        return systemLDAPConfiguration.errorPasswordHistoryKeywords();
    }

    public Properties getGroupMappings(long ldapServerId, long companyId) throws Exception {
        LDAPServerConfiguration ldapServerConfiguration = (LDAPServerConfiguration)this._ldapServerConfigurationProvider.getConfiguration(companyId, ldapServerId);
        Properties groupMappings = this.getProperties(ldapServerConfiguration.groupMappings());
        LogUtil.debug((Log)_log, (Properties)groupMappings);
        return groupMappings;
    }

    public long getPreferredLDAPServerId(long companyId, String screenName) {
        User user = this._userLocalService.fetchUserByScreenName(companyId, screenName);
        if (user == null) {
            return -1L;
        }
        return user.getLdapServerId();
    }

    public String getPropertyPostfix(long ldapServerId) {
        return "." + ldapServerId;
    }

    public Properties getUserExpandoMappings(long ldapServerId, long companyId) throws Exception {
        LDAPServerConfiguration ldapServerConfiguration = (LDAPServerConfiguration)this._ldapServerConfigurationProvider.getConfiguration(companyId, ldapServerId);
        Properties contactExpandoMappings = this.getProperties(ldapServerConfiguration.userCustomMappings());
        LogUtil.debug((Log)_log, (Properties)contactExpandoMappings);
        return contactExpandoMappings;
    }

    public Properties getUserMappings(long ldapServerId, long companyId) throws Exception {
        LDAPServerConfiguration ldapServerConfiguration = (LDAPServerConfiguration)this._ldapServerConfigurationProvider.getConfiguration(companyId, ldapServerId);
        Properties userMappings = this.getProperties(ldapServerConfiguration.userMappings());
        LogUtil.debug((Log)_log, (Properties)userMappings);
        return userMappings;
    }

    public boolean isExportEnabled(long companyId) {
        LDAPImportConfiguration ldapImportConfiguration = (LDAPImportConfiguration)this._ldapImportConfigurationProvider.getConfiguration(companyId);
        boolean defaultImportUserPasswordAutogenerated = ldapImportConfiguration.importUserPasswordAutogenerated();
        if (ldapImportConfiguration.importEnabled() && defaultImportUserPasswordAutogenerated) {
            return false;
        }
        LDAPExportConfiguration ldapExportConfiguration = (LDAPExportConfiguration)this._ldapExportConfigurationProvider.getConfiguration(companyId);
        return ldapExportConfiguration.exportEnabled();
    }

    public boolean isExportGroupEnabled(long companyId) {
        LDAPExportConfiguration ldapExportConfiguration = (LDAPExportConfiguration)this._ldapExportConfigurationProvider.getConfiguration(companyId);
        return ldapExportConfiguration.exportGroupEnabled();
    }

    public boolean isImportEnabled(long companyId) {
        LDAPImportConfiguration ldapImportConfiguration = (LDAPImportConfiguration)this._ldapImportConfigurationProvider.getConfiguration(companyId);
        return ldapImportConfiguration.importEnabled();
    }

    public boolean isImportOnStartup(long companyId) {
        LDAPImportConfiguration ldapImportConfiguration = (LDAPImportConfiguration)this._ldapImportConfigurationProvider.getConfiguration(companyId);
        return ldapImportConfiguration.importOnStartup();
    }

    public boolean isPasswordPolicyEnabled(long companyId) {
        LDAPAuthConfiguration ldapAuthConfiguration = (LDAPAuthConfiguration)this._ldapAuthConfigurationProvider.getConfiguration(companyId);
        return ldapAuthConfiguration.passwordPolicyEnabled();
    }

    protected Properties getProperties(String[] keyValuePairs) {
        Properties properties = new Properties();
        for (String keyValuePair : keyValuePairs) {
            Object[] keyValue = StringUtil.split((String)keyValuePair, (char)'=');
            if (ArrayUtil.isEmpty((Object[])keyValue)) continue;
            Object value = "";
            if (keyValue.length == 2) {
                value = keyValue[1];
            }
            properties.put(keyValue[0], value);
        }
        return properties;
    }

    @Reference(target="(factoryPid=com.liferay.portal.security.ldap.authenticator.configuration.LDAPAuthConfiguration)", unbind="-")
    protected void setLDAPAuthConfigurationProvider(ConfigurationProvider<LDAPAuthConfiguration> ldapAuthConfigurationProvider) {
        this._ldapAuthConfigurationProvider = ldapAuthConfigurationProvider;
    }

    @Reference(target="(factoryPid=com.liferay.portal.security.ldap.exportimport.configuration.LDAPExportConfiguration)", unbind="-")
    protected void setLDAPExportConfigurationProvider(ConfigurationProvider<LDAPExportConfiguration> ldapExportConfigurationProvider) {
        this._ldapExportConfigurationProvider = ldapExportConfigurationProvider;
    }

    @Reference(target="(factoryPid=com.liferay.portal.security.ldap.exportimport.configuration.LDAPImportConfiguration)", unbind="-")
    protected void setLDAPImportConfigurationProvider(ConfigurationProvider<LDAPImportConfiguration> ldapImportConfigurationProvider) {
        this._ldapImportConfigurationProvider = ldapImportConfigurationProvider;
    }

    @Reference(target="(factoryPid=com.liferay.portal.security.ldap.configuration.LDAPServerConfiguration)", unbind="-")
    protected void setLDAPServerConfigurationProvider(ConfigurationProvider<LDAPServerConfiguration> ldapServerConfigurationProvider) {
        this._ldapServerConfigurationProvider = ldapServerConfigurationProvider;
    }

    @Reference(target="(factoryPid=com.liferay.portal.security.ldap.configuration.SystemLDAPConfiguration)", unbind="-")
    protected void setSystemLDAPConfigurationProvider(ConfigurationProvider<SystemLDAPConfiguration> systemLDAPConfigurationProvider) {
        this._systemLDAPConfigurationProvider = systemLDAPConfigurationProvider;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }
}

