/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap.internal.configuration;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.ldap.configuration.ConfigurationProvider;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={ConfigurationListener.class})
public class LDAPConfigurationListener
implements ConfigurationListener {
    private static final Log _log = LogFactoryUtil.getLog(LDAPConfigurationListener.class);
    private ConfigurationAdmin _configurationAdmin;
    private final Map<String, ConfigurationProvider<?>> _configurationProviders = new HashMap();

    public void configurationEvent(ConfigurationEvent configurationEvent) {
        if (Validator.isNull((String)configurationEvent.getFactoryPid()) || !this._configurationProviders.containsKey(configurationEvent.getFactoryPid())) {
            return;
        }
        ConfigurationProvider<?> configurationProvider = this._configurationProviders.get(configurationEvent.getFactoryPid());
        try {
            if (configurationEvent.getType() == 2) {
                configurationProvider.unregisterConfiguration(configurationEvent.getPid());
            } else {
                Configuration configuration = this._configurationAdmin.getConfiguration(configurationEvent.getPid(), "?");
                configurationProvider.registerConfiguration(configuration);
            }
        }
        catch (IOException ioException) {
            throw new SystemException("Unable to load configuration " + configurationEvent.getPid(), (Throwable)ioException);
        }
    }

    @Deactivate
    protected void deactivate() {
        this._configurationProviders.clear();
    }

    @Reference(unbind="-")
    protected void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this._configurationAdmin = configurationAdmin;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected synchronized void setConfigurationProvider(ConfigurationProvider<?> configurationProvider, Map<String, Object> properties) {
        block5: {
            String factoryPid = MapUtil.getString(properties, (String)"factoryPid");
            if (Validator.isNull((String)factoryPid)) {
                throw new IllegalArgumentException("No factory PID specified for configuration provider " + configurationProvider);
            }
            this._configurationProviders.put(factoryPid, configurationProvider);
            try {
                Configuration[] configurations = this._configurationAdmin.listConfigurations("(service.factoryPid=" + factoryPid + ")");
                if (configurations != null) {
                    for (Configuration configuration : configurations) {
                        configurationProvider.registerConfiguration(configuration);
                    }
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block5;
                _log.warn((Object)"Unable to register configurations", (Throwable)exception);
            }
        }
    }

    protected synchronized void unsetConfigurationProvider(ConfigurationProvider<?> configurationProvider, Map<String, Object> properties) {
        String factoryPid = MapUtil.getString(properties, (String)"factoryPid");
        this._configurationProviders.remove(factoryPid);
    }
}

