/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap.internal.authenticator;

import com.liferay.admin.kernel.util.Omniadmin;
import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PasswordExpiredException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.UserLockoutException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.AuthException;
import com.liferay.portal.kernel.security.auth.Authenticator;
import com.liferay.portal.kernel.security.auth.PasswordModificationThreadLocal;
import com.liferay.portal.kernel.security.ldap.LDAPSettings;
import com.liferay.portal.kernel.security.pwd.PasswordEncryptor;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.ldap.PortalLDAP;
import com.liferay.portal.security.ldap.authenticator.configuration.LDAPAuthConfiguration;
import com.liferay.portal.security.ldap.configuration.ConfigurationProvider;
import com.liferay.portal.security.ldap.configuration.LDAPServerConfiguration;
import com.liferay.portal.security.ldap.configuration.SystemLDAPConfiguration;
import com.liferay.portal.security.ldap.exportimport.LDAPUserImporter;
import com.liferay.portal.security.ldap.exportimport.configuration.LDAPImportConfiguration;
import com.liferay.portal.security.ldap.internal.authenticator.LDAPAuthResult;
import com.liferay.portal.security.ldap.util.LDAPUtil;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, property={"key=auth.pipeline.pre"}, service={Authenticator.class})
public class LDAPAuth
implements Authenticator {
    public static final String RESULT_PASSWORD_EXP_WARNING = "2.16.840.1.113730.3.4.5";
    public static final String RESULT_PASSWORD_RESET = "2.16.840.1.113730.3.4.4";
    private static final Log _log = LogFactoryUtil.getLog(LDAPAuth.class);
    private boolean _authPipelineEnableLiferayCheck;
    private final ThreadLocal<Map<String, LDAPAuthResult>> _failedLDAPAuthResults = new CentralizedThreadLocal(LDAPAuth.class + "._failedLDAPAuthResultCache", HashMap::new);
    private ConfigurationProvider<LDAPAuthConfiguration> _ldapAuthConfigurationProvider;
    private ConfigurationProvider<LDAPImportConfiguration> _ldapImportConfigurationProvider;
    private ConfigurationProvider<LDAPServerConfiguration> _ldapServerConfigurationProvider;
    private LDAPSettings _ldapSettings;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile LDAPUserImporter _ldapUserImporter;
    private Omniadmin _omniadmin;
    private PasswordEncryptor _passwordEncryptor;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile PortalLDAP _portalLDAP;
    private Props _props;
    private ConfigurationProvider<SystemLDAPConfiguration> _systemLDAPConfigurationProvider;
    private UserLocalService _userLocalService;

    public int authenticateByEmailAddress(long companyId, String emailAddress, String password, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        try {
            return this.authenticate(companyId, emailAddress, "", 0L, password);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new AuthException((Throwable)exception);
        }
    }

    public int authenticateByScreenName(long companyId, String screenName, String password, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        try {
            return this.authenticate(companyId, "", screenName, 0L, password);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new AuthException((Throwable)exception);
        }
    }

    public int authenticateByUserId(long companyId, long userId, String password, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        try {
            return this.authenticate(companyId, "", "", userId, password);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new AuthException((Throwable)exception);
        }
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._authPipelineEnableLiferayCheck = GetterUtil.getBoolean((String)this._props.get("auth.pipeline.enable.liferay.check"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LDAPAuthResult authenticate(LdapContext ctx, long companyId, Attributes attributes, String userDN, String password) throws Exception {
        LDAPAuthResult ldapAuthResult = null;
        LDAPAuthConfiguration ldapAuthConfiguration = (LDAPAuthConfiguration)this._ldapAuthConfigurationProvider.getConfiguration(companyId);
        String authMethod = ldapAuthConfiguration.method();
        if (authMethod.equals("bind")) {
            Hashtable<String, Object> env = ctx.getEnvironment();
            SystemLDAPConfiguration systemLDAPConfiguration = (SystemLDAPConfiguration)this._systemLDAPConfigurationProvider.getConfiguration(companyId);
            env.put("java.naming.referral", systemLDAPConfiguration.referral());
            env.put("java.naming.security.credentials", password);
            env.put("java.naming.security.principal", userDN);
            env.put("com.sun.jndi.ldap.connect.pool", "false");
            ldapAuthResult = this.getFailedLDAPAuthResult(env);
            if (ldapAuthResult != null) {
                return ldapAuthResult;
            }
            ldapAuthResult = new LDAPAuthResult();
            try (InitialLdapContext initialLdapContext = null;){
                initialLdapContext = new InitialLdapContext(env, null);
                ldapAuthResult.setAuthenticated(true);
                ldapAuthResult.setResponseControl(initialLdapContext.getResponseControls());
            }
        } else if (authMethod.equals("password-compare")) {
            ldapAuthResult = new LDAPAuthResult();
            Attribute userPassword = attributes.get("userPassword");
            if (userPassword != null) {
                String encryptedPassword = password;
                String ldapPassword = new String((byte[])userPassword.get());
                if (Validator.isNotNull((String)ldapAuthConfiguration.passwordEncryptionAlgorithm())) {
                    ldapPassword = this.removeEncryptionAlgorithm(ldapPassword);
                    encryptedPassword = this._passwordEncryptor.encrypt(ldapAuthConfiguration.passwordEncryptionAlgorithm(), password, ldapPassword);
                }
                if (ldapPassword.equals(encryptedPassword)) {
                    ldapAuthResult.setAuthenticated(true);
                } else {
                    ldapAuthResult.setAuthenticated(false);
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("Passwords do not match for userDN " + userDN));
                    }
                }
            }
        }
        return ldapAuthResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int authenticate(long ldapServerId, long companyId, String emailAddress, String screenName, long userId, String password) throws Exception {
        LdapContext ldapContext = this._portalLDAP.getContext(ldapServerId, companyId);
        if (ldapContext == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"No LDAP server configuration available for LDAP ", "server ", ldapServerId, " and company ", companyId}));
            }
            return -1;
        }
        NamingEnumeration<SearchResult> enu = null;
        try {
            String errorMessage;
            SearchResult searchResult;
            String fullUserDN;
            Attributes attributes;
            LDAPAuthResult ldapAuthResult;
            LDAPServerConfiguration ldapServerConfiguration = (LDAPServerConfiguration)this._ldapServerConfigurationProvider.getConfiguration(companyId, ldapServerId);
            String baseDN = LDAPUtil.escapeCharacters((String)ldapServerConfiguration.baseDN());
            String filter = this._ldapSettings.getAuthSearchFilter(ldapServerId, companyId, this._portalLDAP.encodeFilterAttribute(emailAddress, false), this._portalLDAP.encodeFilterAttribute(screenName, false), String.valueOf(userId));
            Properties userMappings = this._ldapSettings.getUserMappings(ldapServerId, companyId);
            String userMappingsScreenName = GetterUtil.getString((String)userMappings.getProperty("screenName"));
            userMappingsScreenName = StringUtil.toLowerCase((String)userMappingsScreenName);
            SearchControls searchControls = new SearchControls(2, 1L, 0, new String[]{userMappingsScreenName}, false, false);
            enu = ldapContext.search(baseDN, filter, searchControls);
            if (!enu.hasMoreElements()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("No results found with search filter: " + filter));
                }
                int n = 0;
                return n;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Found results with search filter: " + filter));
            }
            if (!(ldapAuthResult = this.authenticate(ldapContext, companyId, attributes = this._portalLDAP.getUserAttributes(ldapServerId, companyId, ldapContext, fullUserDN = (searchResult = (SearchResult)enu.nextElement()).getNameInNamespace()), fullUserDN, password)).isAuthenticated()) {
                password = null;
            }
            User user = this._ldapUserImporter.importUser(ldapServerId, companyId, ldapContext, attributes, password);
            if (!ldapAuthResult.isAuthenticated()) {
                PasswordModificationThreadLocal.setPasswordModified((boolean)false);
            }
            if ((errorMessage = ldapAuthResult.getErrorMessage()) != null) {
                SystemLDAPConfiguration systemLDAPConfiguration = (SystemLDAPConfiguration)this._systemLDAPConfigurationProvider.getConfiguration(companyId);
                for (String errorUserLockoutKeyword : systemLDAPConfiguration.errorUserLockoutKeywords()) {
                    if (!errorMessage.contains(errorUserLockoutKeyword)) continue;
                    throw new UserLockoutException.LDAPLockout(fullUserDN, errorMessage);
                }
                for (String errorPasswordExpiredKeyword : systemLDAPConfiguration.errorPasswordExpiredKeywords()) {
                    if (!errorMessage.contains(errorPasswordExpiredKeyword)) continue;
                    throw new PasswordExpiredException();
                }
            }
            if (!ldapAuthResult.isAuthenticated()) {
                if (_log.isDebugEnabled()) {
                    StringBundler sb = new StringBundler(10);
                    sb.append("Uanble to authenticate with ");
                    sb.append(fullUserDN);
                    sb.append(" on LDAP server ");
                    sb.append(ldapServerId);
                    sb.append(", company ");
                    sb.append(companyId);
                    sb.append(", and LDAP context ");
                    sb.append((Object)ldapContext);
                    sb.append(": ");
                    sb.append(errorMessage);
                    _log.debug((Object)sb.toString());
                }
                int sb = -1;
                return sb;
            }
            String resultCode = ldapAuthResult.getResponseControl();
            if (resultCode.equals(RESULT_PASSWORD_RESET)) {
                this._userLocalService.updatePasswordReset(user.getUserId(), true);
            }
        }
        catch (Exception exception) {
            if (exception instanceof PasswordExpiredException || exception instanceof UserLockoutException) {
                throw exception;
            }
            _log.error((Object)"Problem accessing LDAP server", (Throwable)exception);
            int n = -1;
            return n;
        }
        finally {
            if (enu != null) {
                enu.close();
            }
            ldapContext.close();
        }
        return 1;
    }

    protected int authenticate(long companyId, String emailAddress, String screenName, long userId, String password) throws Exception {
        LDAPAuthConfiguration ldapAuthConfiguration = (LDAPAuthConfiguration)this._ldapAuthConfigurationProvider.getConfiguration(companyId);
        if (!ldapAuthConfiguration.enabled()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Authenticator is not enabled");
            }
            return 1;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Authenticator is enabled");
        }
        long preferredLDAPServerId = this.getPreferredLDAPServer(companyId, emailAddress, screenName, userId);
        int preferredLDAPServerResult = this.authenticateAgainstPreferredLDAPServer(companyId, preferredLDAPServerId, emailAddress, screenName, userId, password);
        LDAPImportConfiguration ldapImportConfiguration = (LDAPImportConfiguration)this._ldapImportConfigurationProvider.getConfiguration(companyId);
        if (preferredLDAPServerResult == 1) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Found preferred LDAP server");
            }
            if (ldapImportConfiguration.importUserPasswordEnabled()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Import user password enabled");
                }
                return preferredLDAPServerResult;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Import user password disabled");
            }
            return 2;
        }
        List ldapServerConfigurations = this._ldapServerConfigurationProvider.getConfigurations(companyId);
        for (LDAPServerConfiguration ldapServerConfiguration : ldapServerConfigurations) {
            if (preferredLDAPServerId == ldapServerConfiguration.ldapServerId()) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)"Bypassing preferred LDAP server");
                continue;
            }
            int result = this.authenticate(ldapServerConfiguration.ldapServerId(), companyId, emailAddress, screenName, userId, password);
            if (result != 1) continue;
            if (ldapImportConfiguration.importUserPasswordEnabled()) {
                return result;
            }
            return 2;
        }
        return this.authenticateRequired(companyId, userId, emailAddress, screenName, true, -1);
    }

    protected int authenticateAgainstPreferredLDAPServer(long companyId, long ldapServerId, String emailAddress, String screenName, long userId, String password) throws Exception {
        int result = 0;
        if (ldapServerId < 0L) {
            return result;
        }
        LDAPServerConfiguration ldapServerConfiguration = (LDAPServerConfiguration)this._ldapServerConfigurationProvider.getConfiguration(companyId, ldapServerId);
        String providerUrl = ldapServerConfiguration.baseProviderURL();
        if (Validator.isNull((String)providerUrl)) {
            return result;
        }
        return this.authenticate(ldapServerId, companyId, emailAddress, screenName, userId, password);
    }

    protected int authenticateOmniadmin(long companyId, String emailAddress, String screenName, long userId) throws Exception {
        User user;
        if (!this._authPipelineEnableLiferayCheck) {
            return -1;
        }
        if (userId > 0L ? this._omniadmin.isOmniadmin(userId) : (Validator.isNotNull((String)emailAddress) ? (user = this._userLocalService.fetchUserByEmailAddress(companyId, emailAddress)) != null && this._omniadmin.isOmniadmin(user) : Validator.isNotNull((String)screenName) && (user = this._userLocalService.fetchUserByScreenName(companyId, screenName)) != null && this._omniadmin.isOmniadmin(user))) {
            return 1;
        }
        return -1;
    }

    protected int authenticateRequired(long companyId, long userId, String emailAddress, String screenName, boolean allowOmniadmin, int failureCode) throws Exception {
        int code;
        if (allowOmniadmin && (code = this.authenticateOmniadmin(companyId, emailAddress, screenName, userId)) == 1) {
            return 1;
        }
        LDAPAuthConfiguration ldapAuthConfiguration = (LDAPAuthConfiguration)this._ldapAuthConfigurationProvider.getConfiguration(companyId);
        if (ldapAuthConfiguration.required()) {
            return failureCode;
        }
        return 1;
    }

    protected LDAPAuthResult getFailedLDAPAuthResult(Map<String, Object> env) {
        Map<String, LDAPAuthResult> failedLDAPAuthResults = this._failedLDAPAuthResults.get();
        String cacheKey = this.getKey(env);
        return failedLDAPAuthResults.get(cacheKey);
    }

    protected String getKey(Map<String, Object> env) {
        StringBundler sb = new StringBundler(5);
        sb.append(MapUtil.getString(env, (String)"java.naming.provider.url"));
        sb.append("#");
        sb.append(MapUtil.getString(env, (String)"java.naming.security.principal"));
        sb.append("#");
        sb.append(MapUtil.getString(env, (String)"java.naming.security.credentials"));
        return sb.toString();
    }

    protected long getPreferredLDAPServer(long companyId, String emailAddress, String screenName, long userId) throws PortalException {
        User user = null;
        if (userId > 0L) {
            user = this._userLocalService.fetchUserById(userId);
        } else if (Validator.isNotNull((String)emailAddress)) {
            user = this._userLocalService.fetchUserByEmailAddress(companyId, emailAddress);
        } else if (Validator.isNotNull((String)screenName)) {
            user = this._userLocalService.fetchUserByScreenName(companyId, screenName);
        } else {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to get preferred LDAP server");
            }
            return -1L;
        }
        if (user == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to get user " + userId));
            }
            return -1L;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Using LDAP server ", user.getLdapServerId(), " to authenticate user ", userId}));
        }
        return user.getLdapServerId();
    }

    protected String removeEncryptionAlgorithm(String ldapPassword) {
        int x;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Removing encryption algorithm");
        }
        if ((x = ldapPassword.indexOf("{")) == -1) {
            return ldapPassword;
        }
        int y = ldapPassword.indexOf("}", x);
        if (y == -1) {
            return ldapPassword;
        }
        return ldapPassword.substring(y + 1);
    }

    @Reference(target="(factoryPid=com.liferay.portal.security.ldap.authenticator.configuration.LDAPAuthConfiguration)", unbind="-")
    protected void setConfigurationProvider(ConfigurationProvider<LDAPAuthConfiguration> ldapAuthConfigurationProvider) {
        this._ldapAuthConfigurationProvider = ldapAuthConfigurationProvider;
    }

    protected void setFailedLDAPAuthResult(Map<String, Object> env, LDAPAuthResult ldapAuthResult) {
        String cacheKey;
        Map<String, LDAPAuthResult> failedLDAPAuthResults = this._failedLDAPAuthResults.get();
        if (failedLDAPAuthResults.containsKey(cacheKey = this.getKey(env))) {
            return;
        }
        failedLDAPAuthResults.put(cacheKey, ldapAuthResult);
    }

    @Reference(target="(factoryPid=com.liferay.portal.security.ldap.exportimport.configuration.LDAPImportConfiguration)", unbind="-")
    protected void setLDAPImportConfigurationProvider(ConfigurationProvider<LDAPImportConfiguration> ldapImportConfigurationProvider) {
        this._ldapImportConfigurationProvider = ldapImportConfigurationProvider;
    }

    @Reference(target="(factoryPid=com.liferay.portal.security.ldap.configuration.LDAPServerConfiguration)", unbind="-")
    protected void setLDAPServerConfigurationProvider(ConfigurationProvider<LDAPServerConfiguration> ldapServerConfigurationProvider) {
        this._ldapServerConfigurationProvider = ldapServerConfigurationProvider;
    }

    @Reference(unbind="-")
    protected void setLdapSettings(LDAPSettings ldapSettings) {
        this._ldapSettings = ldapSettings;
    }

    @Reference(unbind="-")
    protected void setOmniadmin(Omniadmin omniadmin) {
        this._omniadmin = omniadmin;
    }

    @Reference(unbind="-")
    protected void setPasswordEncryptor(PasswordEncryptor passwordEncryptor) {
        this._passwordEncryptor = passwordEncryptor;
    }

    @Reference(unbind="-")
    protected void setProps(Props props) {
        this._props = props;
    }

    @Reference(target="(factoryPid=com.liferay.portal.security.ldap.configuration.SystemLDAPConfiguration)", unbind="-")
    protected void setSystemLDAPConfigurationProvider(ConfigurationProvider<SystemLDAPConfiguration> systemLDAPConfigurationProvider) {
        this._systemLDAPConfigurationProvider = systemLDAPConfigurationProvider;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }
}

