/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap.internal.verify;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.security.ldap.LDAPSettings;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PrefsProps;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.security.ldap.authenticator.configuration.LDAPAuthConfiguration;
import com.liferay.portal.security.ldap.configuration.ConfigurationProvider;
import com.liferay.portal.security.ldap.configuration.LDAPServerConfiguration;
import com.liferay.portal.security.ldap.configuration.SystemLDAPConfiguration;
import com.liferay.portal.security.ldap.constants.LegacyLDAPPropsKeys;
import com.liferay.portal.security.ldap.exportimport.configuration.LDAPExportConfiguration;
import com.liferay.portal.security.ldap.exportimport.configuration.LDAPImportConfiguration;
import com.liferay.portal.verify.VerifyProcess;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"verify.process.name=com.liferay.portal.security.ldap"}, service={VerifyProcess.class})
public class LDAPPropertiesVerifyProcess
extends VerifyProcess {
    private static final Log _log = LogFactoryUtil.getLog(LDAPPropertiesVerifyProcess.class);
    private CompanyLocalService _companyLocalService;
    private ConfigurationProvider<LDAPAuthConfiguration> _ldapAuthConfigurationProvider;
    private ConfigurationProvider<LDAPExportConfiguration> _ldapExportConfigurationProvider;
    private ConfigurationProvider<LDAPImportConfiguration> _ldapImportConfigurationProvider;
    private ConfigurationProvider<LDAPServerConfiguration> _ldapServerConfigurationProvider;
    private LDAPSettings _ldapSettings;
    private PrefsProps _prefsProps;
    private Props _props;
    private ConfigurationProvider<SystemLDAPConfiguration> _systemLDAPConfigurationProvider;

    protected void doVerify() throws Exception {
        this.verifyLDAPProperties();
    }

    @Reference(unbind="-")
    protected void setCompanyLocalService(CompanyLocalService companyLocalService) {
        this._companyLocalService = companyLocalService;
    }

    @Reference(target="(factoryPid=com.liferay.portal.security.ldap.authenticator.configuration.LDAPAuthConfiguration)", unbind="-")
    protected void setLDAPAuthConfigurationProvider(ConfigurationProvider<LDAPAuthConfiguration> ldapAuthConfigurationProvider) {
        this._ldapAuthConfigurationProvider = ldapAuthConfigurationProvider;
    }

    @Reference(target="(factoryPid=com.liferay.portal.security.ldap.exportimport.configuration.LDAPExportConfiguration)", unbind="-")
    protected void setLDAPExportConfigurationProvider(ConfigurationProvider<LDAPExportConfiguration> ldapExportConfigurationProvider) {
        this._ldapExportConfigurationProvider = ldapExportConfigurationProvider;
    }

    @Reference(target="(factoryPid=com.liferay.portal.security.ldap.exportimport.configuration.LDAPImportConfiguration)", unbind="-")
    protected void setLDAPImportConfigurationProvider(ConfigurationProvider<LDAPImportConfiguration> ldapImportConfigurationProvider) {
        this._ldapImportConfigurationProvider = ldapImportConfigurationProvider;
    }

    @Reference(target="(factoryPid=com.liferay.portal.security.ldap.configuration.LDAPServerConfiguration)", unbind="-")
    protected void setLDAPServerConfigurationProvider(ConfigurationProvider<LDAPServerConfiguration> ldapServerConfigurationProvider) {
        this._ldapServerConfigurationProvider = ldapServerConfigurationProvider;
    }

    @Reference(unbind="-")
    protected void setLdapSettings(LDAPSettings ldapSettings) {
        this._ldapSettings = ldapSettings;
    }

    @Reference(unbind="-")
    protected void setPrefsProps(PrefsProps prefsProps) {
        this._prefsProps = prefsProps;
    }

    @Reference(unbind="-")
    protected void setProps(Props props) {
        this._props = props;
    }

    @Reference(target="(factoryPid=com.liferay.portal.security.ldap.configuration.SystemLDAPConfiguration)", unbind="-")
    protected void setSystemLDAPConfigurationProvider(ConfigurationProvider<SystemLDAPConfiguration> systemLDAPConfigurationProvider) {
        this._systemLDAPConfigurationProvider = systemLDAPConfigurationProvider;
    }

    protected void verifyLDAPAuthProperties(long companyId) {
        HashMapDictionary dictionary = new HashMapDictionary();
        dictionary.put("enabled", this._prefsProps.getBoolean(companyId, "ldap.auth.enabled", false));
        dictionary.put("method", this._prefsProps.getString(companyId, "ldap.auth.method", "bind"));
        dictionary.put("required", this._prefsProps.getBoolean(companyId, "ldap.auth.required", false));
        dictionary.put("passwordEncryptionAlgorithm", this._prefsProps.getString(companyId, "ldap.auth.password.encryption.algorithm", "NONE"));
        dictionary.put("passwordPolicyEnabled", this._prefsProps.getBoolean(companyId, "ldap.password.policy.enabled", false));
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Adding LDAP auth configuration for company ", companyId, " with properties: ", dictionary}));
        }
        this._ldapAuthConfigurationProvider.updateProperties(companyId, (Dictionary)dictionary);
    }

    protected void verifyLDAPExportProperties(long companyId) {
        HashMapDictionary dictionary = new HashMapDictionary();
        dictionary.put("exportEnabled", this._prefsProps.getBoolean(companyId, "ldap.export.enabled", false));
        dictionary.put("exportGroupEnabled", this._prefsProps.getBoolean(companyId, "ldap.export.group.enabled", false));
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Adding LDAP export configuration for company ", companyId, " with properties: ", dictionary}));
        }
        this._ldapExportConfigurationProvider.updateProperties(companyId, (Dictionary)dictionary);
    }

    protected void verifyLDAPImportProperties(long companyId) {
        HashMapDictionary dictionary = new HashMapDictionary();
        dictionary.put("importCreateRolePerGroup", this._prefsProps.getBoolean(companyId, "ldap.import.create.role.per.group", false));
        dictionary.put("importEnabled", this._prefsProps.getBoolean(companyId, "ldap.import.enabled", false));
        dictionary.put("importGroupCacheEnabled", this._prefsProps.getBoolean(companyId, "ldap.import.group.cache.enabled", false));
        dictionary.put("importInterval", this._prefsProps.getInteger(companyId, "ldap.import.interval", 10));
        dictionary.put("importLockExpirationTime", this._prefsProps.getLong(companyId, "ldap.import.lock.expiration.time", 86400000L));
        dictionary.put("importMethod", this._prefsProps.getString(companyId, "ldap.import.method", "user"));
        dictionary.put("importOnStartup", this._prefsProps.getBoolean(companyId, "ldap.import.on.startup", false));
        dictionary.put("importUserPasswordAutogenerated", this._prefsProps.getBoolean(companyId, "ldap.import.user.password.autogenerated", false));
        dictionary.put("importUserPasswordDefault", this._prefsProps.getString(companyId, "ldap.import.user.password.default", "test"));
        dictionary.put("importUserPasswordEnabled", this._prefsProps.getBoolean(companyId, "ldap.import.user.password.enabled", true));
        dictionary.put("importUserSyncStrategy", this._prefsProps.getString(companyId, "ldap.import.user.sync.strategy", "auth-type"));
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Adding LDAP import configuration for company ", companyId, " with properties: ", dictionary}));
        }
        this._ldapImportConfigurationProvider.updateProperties(companyId, (Dictionary)dictionary);
    }

    protected void verifyLDAPProperties() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            List companies = this._companyLocalService.getCompanies(false);
            for (Company company : companies) {
                long companyId = company.getCompanyId();
                long[] ldapServerIds = StringUtil.split((String)this._prefsProps.getString(companyId, "ldap.server.ids"), (long)0L);
                if (ArrayUtil.isEmpty((long[])ldapServerIds)) continue;
                this.verifyLDAPAuthProperties(companyId);
                this.verifyLDAPExportProperties(companyId);
                this.verifyLDAPImportProperties(companyId);
                this.verifySystemLDAPConfiguration(companyId);
                HashSet<String> keys = new HashSet<String>();
                Collections.addAll(keys, LegacyLDAPPropsKeys.LDAP_KEYS_NONPOSTFIXED);
                for (long ldapServerId : ldapServerIds) {
                    String postfix = this._ldapSettings.getPropertyPostfix(ldapServerId);
                    this.verifyLDAPServerConfiguration(companyId, ldapServerId, postfix);
                    for (int i = 0; i < LegacyLDAPPropsKeys.LDAP_KEYS_POSTFIXED.length; ++i) {
                        keys.add(LegacyLDAPPropsKeys.LDAP_KEYS_POSTFIXED[i] + postfix);
                    }
                }
                if (_log.isInfoEnabled()) {
                    _log.info((Object)StringBundler.concat((Object[])new Object[]{"Removing preference keys ", keys, " for company ", companyId}));
                }
                this._companyLocalService.removePreferences(companyId, keys.toArray(new String[0]));
                UnicodeProperties properties = new UnicodeProperties();
                properties.put("ldap.server.ids", "");
                if (_log.isInfoEnabled()) {
                    _log.info((Object)StringBundler.concat((Object[])new Object[]{"Removing LDAP server IDs ", ListUtil.fromArray((long[])ldapServerIds), " for company ", companyId}));
                }
                this._companyLocalService.updatePreferences(companyId, properties);
            }
        }
    }

    protected void verifyLDAPServerConfiguration(long companyId, long ldapServerId, String postfix) {
        HashMapDictionary dictionary = new HashMapDictionary();
        dictionary.put("authSearchFilter", this._prefsProps.getString(companyId, "ldap.auth.search.filter" + postfix, "(mail=@email_address@)"));
        dictionary.put("baseDN", this._prefsProps.getString(companyId, "ldap.base.dn" + postfix, "dc=example,dc=com"));
        dictionary.put("baseProviderURL", this._prefsProps.getString(companyId, "ldap.base.provider.url" + postfix, "ldap://localhost:10389"));
        dictionary.put("contactCustomMappings", this._prefsProps.getStringArray(companyId, "ldap.contact.custom.mappings" + postfix, "\n"));
        dictionary.put("contactMappings", this._prefsProps.getStringArray(companyId, "ldap.contact.mappings" + postfix, "\n"));
        dictionary.put("groupDefaultObjectClasses", this._prefsProps.getStringArray(companyId, "ldap.group.default.object.classes" + postfix, ","));
        dictionary.put("groupMappings", this._prefsProps.getStringArray(companyId, "ldap.group.mappings" + postfix, "\n"));
        dictionary.put("groupSearchFilter", this._prefsProps.getString(companyId, "ldap.import.group.search.filter" + postfix, "(objectClass=groupOfUniqueNames)"));
        dictionary.put("groupSearchFilterEnabled", this._prefsProps.getBoolean(companyId, "ldap.import.group.search.filter.enabled" + postfix, true));
        dictionary.put("groupsDN", this._prefsProps.getString(companyId, "ldap.groups.dn" + postfix, "ou=groups,dc=example,dc=com"));
        dictionary.put("securityCredential", this._prefsProps.getString(companyId, "ldap.security.credentials" + postfix, "secret"));
        dictionary.put("securityPrincipal", this._prefsProps.getString(companyId, "ldap.security.principal" + postfix, "uid=admin,ou=system"));
        dictionary.put("serverName", this._prefsProps.getString(companyId, "ldap.server.name" + postfix));
        dictionary.put("userCustomMappings", this._prefsProps.getStringArray(companyId, "ldap.user.custom.mappings" + postfix, "\n"));
        dictionary.put("userDefaultObjectClasses", this._prefsProps.getStringArray(companyId, "ldap.user.default.object.classes" + postfix, ","));
        dictionary.put("userIgnoreAttributes", this._prefsProps.getStringArray(companyId, "ldap.user.ignore.attributes" + postfix, ","));
        dictionary.put("userMappings", this._prefsProps.getStringArray(companyId, "ldap.user.mappings" + postfix, "\n"));
        dictionary.put("userSearchFilter", this._prefsProps.getString(companyId, "ldap.import.user.search.filter" + postfix, "(objectClass=inetOrgPerson)"));
        dictionary.put("usersDN", this._prefsProps.getString(companyId, "ldap.users.dn" + postfix, "users,dc=example,dc=com"));
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Adding LDAP servier configuration for company ", companyId, " and LDAP server ID ", ldapServerId, " with properties: ", dictionary}));
        }
        this._ldapServerConfigurationProvider.updateProperties(companyId, ldapServerId, (Dictionary)dictionary);
    }

    protected void verifySystemLDAPConfiguration(long companyId) {
        HashMapDictionary dictionary = new HashMapDictionary();
        Properties connectionProperties = this._props.getProperties("ldap.connection.", true);
        ArrayList<String> connectionPropertiesList = new ArrayList<String>(connectionProperties.size());
        for (Map.Entry<Object, Object> entry : connectionProperties.entrySet()) {
            String connectionPropertyString = entry.getKey() + "=" + entry.getValue();
            connectionPropertiesList.add(connectionPropertyString);
        }
        dictionary.put("connectionProperties", connectionPropertiesList.toArray(new String[0]));
        dictionary.put("errorPasswordAgeKeywords", new String[]{this._prefsProps.getString(companyId, "ldap.error.password.age", "age")});
        dictionary.put("errorPasswordExpiredKeywords", new String[]{this._prefsProps.getString(companyId, "ldap.error.password.expired", "expired")});
        dictionary.put("errorPasswordHistoryKeywords", new String[]{this._prefsProps.getString(companyId, "ldap.error.password.history", "history")});
        dictionary.put("errorPasswordNotChangeableKeywords", new String[]{this._prefsProps.getString(companyId, "ldap.error.password.not.changeable", "not allowed to change")});
        dictionary.put("errorPasswordSyntaxKeywords", new String[]{this._prefsProps.getString(companyId, "ldap.error.password.syntax", "syntax")});
        dictionary.put("errorPasswordTrivialTextKeywords", new String[]{this._prefsProps.getString(companyId, "ldap.error.password.trivial", "trivial")});
        dictionary.put("errorUserLockoutKeywords", new String[]{this._prefsProps.getString(companyId, "ldap.error.user.lockout", "retry limit")});
        dictionary.put("factoryInitial", this._prefsProps.getString(companyId, "ldap.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory"));
        dictionary.put("pageSize", this._prefsProps.getInteger(companyId, "ldap.page.size", 1000));
        dictionary.put("rangeSize", this._prefsProps.getInteger(companyId, "ldap.range.size", 1000));
        dictionary.put("referral", this._prefsProps.getString(companyId, "ldap.referral", "follow"));
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Adding system LDAP configurations for company ", companyId, " with properties: ", dictionary}));
        }
        this._systemLDAPConfigurationProvider.updateProperties(companyId, (Dictionary)dictionary);
    }
}

