/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap.internal.messaging.config;

import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.util.HashMapDictionary;
import java.util.Dictionary;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={})
public class MessagingConfigurator {
    private volatile BundleContext _bundleContext;
    private DestinationFactory _destinationFactory;
    private ServiceRegistration<Destination> _serviceRegistration;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        DestinationConfiguration destinationConfiguration = new DestinationConfiguration("serial", "liferay/scheduled_user_ldap_import");
        Destination destination = this._destinationFactory.createDestination(destinationConfiguration);
        HashMapDictionary dictionary = new HashMapDictionary();
        dictionary.put("destination.name", destination.getName());
        this._serviceRegistration = bundleContext.registerService(Destination.class, (Object)destination, (Dictionary)dictionary);
    }

    @Deactivate
    protected void deactivate() {
        if (this._serviceRegistration != null) {
            Destination destination = (Destination)this._bundleContext.getService(this._serviceRegistration.getReference());
            this._serviceRegistration.unregister();
            destination.destroy();
        }
        this._bundleContext = null;
    }

    @Reference(unbind="-")
    protected void setDestinationFactory(DestinationFactory destinationFactory) {
        this._destinationFactory = destinationFactory;
    }
}

