/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap;

import com.liferay.petra.string.StringBundler;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SafeLdapFilter {
    protected static final String ARGUMENT_PLACEHOLDER = "{PLACEHOLDER}";
    private final List<Object> _arguments;
    private final StringBundler _filterSB;
    private String _generatedFilter;

    public SafeLdapFilter and(SafeLdapFilter ... safeLdapFilters) {
        if (safeLdapFilters == null || safeLdapFilters.length == 0) {
            return this;
        }
        StringBundler sb = new StringBundler();
        ArrayList<Object> arguments = new ArrayList<Object>(this._arguments);
        sb.append("(");
        sb.append("&");
        sb.append(this._filterSB);
        for (SafeLdapFilter safeLdapFilter : safeLdapFilters) {
            sb.append(safeLdapFilter._filterSB);
            arguments.addAll(safeLdapFilter._arguments);
        }
        sb.append(")");
        return new SafeLdapFilter(sb, arguments);
    }

    public Object[] getArguments() {
        return this._arguments.toArray();
    }

    public String getFilterString() {
        if (this._generatedFilter != null) {
            return this._generatedFilter;
        }
        StringBundler sb = new StringBundler(this._filterSB.length() + this._arguments.size() * 2);
        int placeholderPos = 0;
        for (int i = 0; i < this._filterSB.index(); ++i) {
            String string = this._filterSB.stringAt(i);
            if (Objects.equals(string, ARGUMENT_PLACEHOLDER)) {
                sb.append("{");
                sb.append(placeholderPos);
                sb.append("}");
                ++placeholderPos;
                continue;
            }
            sb.append(string);
        }
        this._generatedFilter = sb.toString();
        return this._generatedFilter;
    }

    public SafeLdapFilter not() {
        StringBundler sb = new StringBundler(this._filterSB.index() + 3);
        sb.append("(");
        sb.append("!");
        sb.append(this._filterSB);
        sb.append(")");
        return new SafeLdapFilter(sb, new ArrayList<Object>(this._arguments));
    }

    public SafeLdapFilter or(SafeLdapFilter ... safeLdapFilters) {
        if (safeLdapFilters == null || safeLdapFilters.length == 0) {
            return this;
        }
        StringBundler sb = new StringBundler();
        sb.append("(");
        sb.append("|");
        sb.append(this._filterSB);
        ArrayList<Object> arguments = new ArrayList<Object>(this._arguments);
        for (SafeLdapFilter safeLdapFilter : safeLdapFilters) {
            sb.append(safeLdapFilter._filterSB);
            arguments.addAll(safeLdapFilter._arguments);
        }
        sb.append(")");
        return new SafeLdapFilter(sb, arguments);
    }

    public String toString() {
        return StringBundler.concat((Object[])new Object[]{this.getFilterString(), " ", this._arguments});
    }

    protected SafeLdapFilter(StringBundler filterSB, List<Object> arguments) {
        this._filterSB = filterSB;
        this._arguments = arguments;
    }

    protected StringBundler getFilterStringBundler() {
        return this._filterSB;
    }
}

