/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth.verifier.internal.portal.session;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.AccessControlContext;
import com.liferay.portal.kernel.security.auth.AuthException;
import com.liferay.portal.kernel.security.auth.verifier.AuthVerifier;
import com.liferay.portal.kernel.security.auth.verifier.AuthVerifierResult;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class PortalSessionAuthVerifier
implements AuthVerifier {
    public static final String AUTH_TYPE = "FORM";

    public String getAuthType() {
        return AUTH_TYPE;
    }

    public AuthVerifierResult verify(AccessControlContext accessControlContext, Properties properties) throws AuthException {
        try {
            AuthVerifierResult authVerifierResult = new AuthVerifierResult();
            HttpServletRequest request = accessControlContext.getRequest();
            User user = PortalUtil.getUser((HttpServletRequest)request);
            if (user == null || user.isDefaultUser()) {
                return authVerifierResult;
            }
            authVerifierResult.setPasswordBasedAuthentication(true);
            authVerifierResult.setState(AuthVerifierResult.State.SUCCESS);
            authVerifierResult.setUserId(user.getUserId());
            return authVerifierResult;
        }
        catch (PortalException pe) {
            throw new AuthException((Throwable)pe);
        }
        catch (SystemException se) {
            throw new AuthException((Throwable)se);
        }
    }
}

