/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth.verifier.internal.tracker;

import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.osgi.util.StringPlus;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.servlet.filters.authverifier.AuthVerifierFilter;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.http.context.ServletContextHelper;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(immediate=true, property={"default.registration.property=filter.init.auth.verifier.OAuth2RestAuthVerifier.urls.includes=*", "default.registration.property=filter.init.guest.allowed=false", "default.whiteboard.property=osgi.http.whiteboard.filter.servlet=cxf-servlet", "servlet.context.helper.select.filter=(&(!(liferay.auth.verifier=false))(osgi.jaxrs.name=*))"})
public class AuthVerifierFilterTracker {
    public static final String AUTH_VERIFIER_PROPERTY_PREFIX = "auth.verifier.";
    public static final int AUTH_VERIFIER_PROPERTY_PREFIX_LENGTH = "auth.verifier.".length();
    private static final Log _log = LogFactoryUtil.getLog(AuthVerifierFilterTracker.class);
    private BundleContext _bundleContext;
    private Dictionary<String, Object> _defaultRegistrationProperties;
    private Dictionary<String, Object> _defaultWhiteboardProperties;
    private ServiceTracker<?, ?> _serviceTracker;

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this._bundleContext = bundleContext;
        this._defaultRegistrationProperties = this.toDictionary(StringPlus.asList((Object)properties.get("default.registration.property")));
        this._defaultWhiteboardProperties = this.toDictionary(StringPlus.asList((Object)properties.get("default.whiteboard.property")));
        String servletContextHelperSelectFilterString = MapUtil.getString(properties, (String)"servlet.context.helper.select.filter");
        String filterString = StringBundler.concat((String[])new String[]{"(&" + servletContextHelperSelectFilterString + "(", "osgi.http.whiteboard.context.name", "=*)", "(objectClass=", ServletContextHelper.class.getName(), "))"});
        this._serviceTracker = ServiceTrackerFactory.open((BundleContext)bundleContext, (String)filterString, (ServiceTrackerCustomizer)new ServletContextHelperServiceTrackerCustomizer());
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTracker.close();
    }

    protected Dictionary<String, Object> toDictionary(List<String> propertiesList) {
        HashMapDictionary dictionary = new HashMapDictionary();
        for (String property : propertiesList) {
            int index = property.indexOf("=");
            if (index == -1) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Invalid property " + property));
                continue;
            }
            String propertyKey = property.substring(0, index);
            String propertyValue = "";
            if (index < property.length()) {
                propertyValue = property.substring(index + 1);
            }
            dictionary.put(propertyKey, propertyValue);
        }
        return dictionary;
    }

    private class ServletContextHelperServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<ServletContextHelper, ServiceRegistration<?>> {
        private ServletContextHelperServiceTrackerCustomizer() {
        }

        public ServiceRegistration<?> addingService(ServiceReference<ServletContextHelper> serviceReference) {
            return AuthVerifierFilterTracker.this._bundleContext.registerService(Filter.class, (Object)new AuthVerifierFilter(), this._buildProperties(serviceReference));
        }

        public void modifiedService(ServiceReference<ServletContextHelper> serviceReference, ServiceRegistration<?> serviceRegistration) {
            serviceRegistration.setProperties(this._buildProperties(serviceReference));
        }

        public void removedService(ServiceReference<ServletContextHelper> serviceReference, ServiceRegistration<?> serviceRegistration) {
            serviceRegistration.unregister();
        }

        private Dictionary<String, ?> _buildProperties(ServiceReference<ServletContextHelper> serviceReference) {
            HashMapDictionary properties = new HashMapDictionary();
            Enumeration enumeration = AuthVerifierFilterTracker.this._defaultRegistrationProperties.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                properties.put(string, AuthVerifierFilterTracker.this._defaultRegistrationProperties.get(string));
            }
            enumeration = AuthVerifierFilterTracker.this._defaultWhiteboardProperties.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                properties.put(string, AuthVerifierFilterTracker.this._defaultWhiteboardProperties.get(string));
            }
            for (String key2 : serviceReference.getPropertyKeys()) {
                if (key2.startsWith(AuthVerifierFilterTracker.AUTH_VERIFIER_PROPERTY_PREFIX)) {
                    properties.put("filter.init." + key2.substring(AUTH_VERIFIER_PROPERTY_PREFIX_LENGTH), serviceReference.getProperty(key2));
                }
                if (!key2.startsWith("osgi.http.whiteboard")) continue;
                properties.put(key2, serviceReference.getProperty(key2));
            }
            String string = GetterUtil.getString((Object)serviceReference.getProperty("osgi.http.whiteboard.context.name"));
            properties.put("osgi.http.whiteboard.context.select", StringBundler.concat((String[])new String[]{"(", "osgi.http.whiteboard.context.name", "=", string, ")"}));
            return properties;
        }
    }
}

