/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth.verifier.internal.basic.auth.header;

import com.liferay.portal.kernel.security.auth.AccessControlContext;
import com.liferay.portal.kernel.security.auth.AuthException;
import com.liferay.portal.kernel.security.auth.http.HttpAuthManagerUtil;
import com.liferay.portal.kernel.security.auth.http.HttpAuthorizationHeader;
import com.liferay.portal.kernel.security.auth.verifier.AuthVerifier;
import com.liferay.portal.kernel.security.auth.verifier.AuthVerifierResult;
import com.liferay.portal.kernel.security.auto.login.AutoLogin;
import com.liferay.portal.kernel.security.auto.login.AutoLoginException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BasicAuthHeaderAuthVerifier
implements AuthVerifier {
    private final AutoLogin _autoLogin;

    public BasicAuthHeaderAuthVerifier(AutoLogin autoLogin) {
        this._autoLogin = autoLogin;
    }

    public String getAuthType() {
        return "BASIC";
    }

    public AuthVerifierResult verify(AccessControlContext accessControlContext, Properties properties) throws AuthException {
        try {
            AuthVerifierResult authVerifierResult = new AuthVerifierResult();
            String[] credentials = this._autoLogin.login(accessControlContext.getRequest(), accessControlContext.getResponse());
            if (credentials != null) {
                authVerifierResult.setPassword(credentials[1]);
                authVerifierResult.setPasswordBasedAuthentication(true);
                authVerifierResult.setState(AuthVerifierResult.State.SUCCESS);
                authVerifierResult.setUserId(Long.valueOf(credentials[0]).longValue());
            } else {
                boolean forcedBasicAuth = MapUtil.getBoolean((Map)accessControlContext.getSettings(), (String)"basic_auth");
                if (!forcedBasicAuth) {
                    forcedBasicAuth = GetterUtil.getBoolean((String)properties.getProperty("basic_auth"));
                }
                if (forcedBasicAuth) {
                    HttpAuthorizationHeader httpAuthorizationHeader = new HttpAuthorizationHeader("Basic");
                    HttpAuthManagerUtil.generateChallenge((HttpServletRequest)accessControlContext.getRequest(), (HttpServletResponse)accessControlContext.getResponse(), (HttpAuthorizationHeader)httpAuthorizationHeader);
                    authVerifierResult.setState(AuthVerifierResult.State.INVALID_CREDENTIALS);
                }
            }
            return authVerifierResult;
        }
        catch (AutoLoginException ale) {
            throw new AuthException((Throwable)ale);
        }
    }
}

