/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth.verifier.digest.authentication;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.security.auth.AccessControlContext;
import com.liferay.portal.kernel.security.auth.AuthException;
import com.liferay.portal.kernel.security.auth.http.HttpAuthManagerUtil;
import com.liferay.portal.kernel.security.auth.http.HttpAuthorizationHeader;
import com.liferay.portal.kernel.security.auth.verifier.AuthVerifier;
import com.liferay.portal.kernel.security.auth.verifier.AuthVerifierResult;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DigestAuthenticationAuthVerifier
implements AuthVerifier {
    public String getAuthType() {
        return "DIGEST";
    }

    public AuthVerifierResult verify(AccessControlContext accessControlContext, Properties configuration) throws AuthException {
        try {
            AuthVerifierResult authVerifierResult = new AuthVerifierResult();
            HttpServletRequest request = accessControlContext.getRequest();
            long userId = HttpAuthManagerUtil.getDigestUserId((HttpServletRequest)request);
            if (userId == 0L) {
                boolean forcedDigestAuth = MapUtil.getBoolean((Map)accessControlContext.getSettings(), (String)"digest_auth");
                if (!forcedDigestAuth) {
                    forcedDigestAuth = GetterUtil.getBoolean((String)configuration.getProperty("digest_auth"));
                }
                if (forcedDigestAuth) {
                    HttpAuthorizationHeader httpAuthorizationHeader = new HttpAuthorizationHeader("Digest");
                    HttpAuthManagerUtil.generateChallenge((HttpServletRequest)request, (HttpServletResponse)accessControlContext.getResponse(), (HttpAuthorizationHeader)httpAuthorizationHeader);
                    authVerifierResult.setState(AuthVerifierResult.State.INVALID_CREDENTIALS);
                }
                return authVerifierResult;
            }
            authVerifierResult.setPasswordBasedAuthentication(true);
            authVerifierResult.setState(AuthVerifierResult.State.SUCCESS);
            authVerifierResult.setUserId(userId);
            return authVerifierResult;
        }
        catch (PortalException pe) {
            throw new AuthException((Throwable)pe);
        }
        catch (SystemException se) {
            throw new AuthException((Throwable)se);
        }
    }
}

