/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.audit.router.internal;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.change.tracking.CTTransactionException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.BatchProcessor;
import com.liferay.portal.security.audit.AuditEventManager;
import com.liferay.portal.security.audit.AuditMessageProcessor;
import com.liferay.portal.security.audit.router.configuration.PersistentAuditMessageProcessorConfiguration;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.security.audit.router.configuration.PersistentAuditMessageProcessorConfiguration"}, property={"eventTypes=*"}, service={AuditMessageProcessor.class})
public class PersistentAuditMessageProcessor
implements AuditMessageProcessor {
    private static final Log _log = LogFactoryUtil.getLog(PersistentAuditMessageProcessor.class);
    @Reference
    private AuditEventManager _auditEventManager;
    private volatile BatchProcessor<AuditMessage> _batchProcessor;
    private volatile PersistentAuditMessageProcessorConfiguration _persistentAuditMessageProcessorConfiguration;

    public void process(AuditMessage auditMessage) {
        try {
            this.doProcess(auditMessage);
        }
        catch (CTTransactionException ctTransactionException) {
            throw ctTransactionException;
        }
        catch (Exception exception) {
            _log.fatal((Object)("Unable to process audit message " + auditMessage), (Throwable)exception);
        }
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this.modified(properties);
    }

    @Deactivate
    protected void deactivate() {
        this._batchProcessor.close();
    }

    protected void doProcess(AuditMessage auditMessage) throws Exception {
        PersistentAuditMessageProcessorConfiguration persistentAuditMessageProcessorConfiguration = this._persistentAuditMessageProcessorConfiguration;
        if (!persistentAuditMessageProcessorConfiguration.enabled()) {
            return;
        }
        this._batchProcessor.add((Object)auditMessage);
    }

    @Modified
    protected void modified(Map<String, Object> properties) {
        this._persistentAuditMessageProcessorConfiguration = (PersistentAuditMessageProcessorConfiguration)ConfigurableUtil.createConfigurable(PersistentAuditMessageProcessorConfiguration.class, properties);
        if (!this._persistentAuditMessageProcessorConfiguration.enabled()) {
            return;
        }
        if (this._batchProcessor == null) {
            this._batchProcessor = new BatchProcessor(this._persistentAuditMessageProcessorConfiguration.flushInterval(), this._persistentAuditMessageProcessorConfiguration.bufferSize(), arg_0 -> ((AuditEventManager)this._auditEventManager).addAuditEvents(arg_0), PersistentAuditMessageProcessor.class.getName());
        } else {
            this._batchProcessor.configure(this._persistentAuditMessageProcessorConfiguration.flushInterval(), this._persistentAuditMessageProcessorConfiguration.bufferSize());
        }
    }
}

