/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.audit.router.internal;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.audit.AuditMessageProcessor;
import com.liferay.portal.security.audit.formatter.LogMessageFormatter;
import com.liferay.portal.security.audit.router.configuration.LoggingAuditMessageProcessorConfiguration;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;

@Component(configurationPid={"com.liferay.portal.security.audit.router.configuration.LoggingAuditMessageProcessorConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"eventTypes=*"}, service={AuditMessageProcessor.class})
public class LoggingAuditMessageProcessor
implements AuditMessageProcessor {
    private static final Log _log = LogFactoryUtil.getLog(LoggingAuditMessageProcessor.class);
    private volatile LoggingAuditMessageProcessorConfiguration _loggingAuditMessageProcessorConfiguration;
    private volatile ServiceTrackerMap<String, LogMessageFormatter> _serviceTrackerMap;

    public void process(AuditMessage auditMessage) {
        try {
            this.doProcess(auditMessage);
        }
        catch (Exception exception) {
            _log.fatal((Object)("Unable to process audit message " + auditMessage), (Throwable)exception);
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this._loggingAuditMessageProcessorConfiguration = (LoggingAuditMessageProcessorConfiguration)ConfigurableUtil.createConfigurable(LoggingAuditMessageProcessorConfiguration.class, properties);
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, LogMessageFormatter.class, null, (serviceReference, emitter) -> {
            String format = (String)serviceReference.getProperty("format");
            if (Validator.isNull((String)format)) {
                throw new IllegalArgumentException("The property \"format\" is null");
            }
            emitter.emit((Object)format);
        });
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    protected void doProcess(AuditMessage auditMessage) throws Exception {
        if (this._loggingAuditMessageProcessorConfiguration.enabled() && (_log.isInfoEnabled() || this._loggingAuditMessageProcessorConfiguration.outputToConsole())) {
            LogMessageFormatter logMessageFormatter = (LogMessageFormatter)this._serviceTrackerMap.getService((Object)this._loggingAuditMessageProcessorConfiguration.logMessageFormat());
            if (logMessageFormatter == null) {
                if (_log.isWarnEnabled()) {
                    String logMessageFormat = this._loggingAuditMessageProcessorConfiguration.logMessageFormat();
                    _log.warn((Object)("No log message formatter found for log message format " + logMessageFormat));
                }
                return;
            }
            String logMessage = logMessageFormatter.format(auditMessage);
            if (_log.isInfoEnabled()) {
                _log.info((Object)logMessage);
            }
            if (this._loggingAuditMessageProcessorConfiguration.outputToConsole()) {
                System.out.println("LoggingAuditMessageProcessor: " + logMessage);
            }
        }
    }
}

