/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.audit.router.internal;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.audit.AuditException;
import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.audit.AuditRouter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.security.audit.AuditMessageProcessor;
import com.liferay.portal.security.audit.configuration.AuditConfiguration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"com.liferay.portal.security.audit.configuration.AuditConfiguration"}, service={AuditRouter.class})
public class DefaultAuditRouter
implements AuditRouter {
    private static final Log _log = LogFactoryUtil.getLog(DefaultAuditRouter.class);
    private volatile boolean _auditEnabled;
    private ServiceTrackerMap<String, List<AuditMessageProcessor>> _serviceTrackerMap;

    public boolean isDeployed() {
        Set keys = this._serviceTrackerMap.keySet();
        return !keys.isEmpty();
    }

    public void route(AuditMessage auditMessage) throws AuditException {
        List auditMessageProcessors;
        if (!this._auditEnabled) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Audit disabled, not processing message: " + auditMessage));
            }
            return;
        }
        List globalAuditMessageProcessors = (List)this._serviceTrackerMap.getService((Object)"*");
        if (globalAuditMessageProcessors != null) {
            for (AuditMessageProcessor globalAuditMessageProcessor : globalAuditMessageProcessors) {
                globalAuditMessageProcessor.process(auditMessage);
            }
        }
        if ((auditMessageProcessors = (List)this._serviceTrackerMap.getService((Object)auditMessage.getEventType())) != null) {
            for (AuditMessageProcessor auditMessageProcessor : auditMessageProcessors) {
                auditMessageProcessor.process(auditMessage);
            }
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        AuditConfiguration auditConfiguration = (AuditConfiguration)ConfigurableUtil.createConfigurable(AuditConfiguration.class, properties);
        this._auditEnabled = auditConfiguration.enabled();
        this._serviceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)bundleContext, AuditMessageProcessor.class, (String)"eventTypes");
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    @Modified
    protected void modified(Map<String, Object> properties) {
        AuditConfiguration auditConfiguration = (AuditConfiguration)ConfigurableUtil.createConfigurable(AuditConfiguration.class, properties);
        this._auditEnabled = auditConfiguration.enabled();
    }
}

