/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.audit.router.internal;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.audit.AuditException;
import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.audit.AuditRouter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.proxy.ProxyMessageListener;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.audit.AuditMessageProcessor;
import com.liferay.portal.security.audit.configuration.AuditConfiguration;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(configurationPid={"com.liferay.portal.security.audit.configuration.AuditConfiguration"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, immediate=true, service={DefaultAuditRouter.class})
public class DefaultAuditRouter
implements AuditRouter {
    private static final Log _log = LogFactoryUtil.getLog(DefaultAuditRouter.class);
    private volatile boolean _auditEnabled;
    private final Map<String, Set<AuditMessageProcessor>> _auditMessageProcessors = new ConcurrentHashMap<String, Set<AuditMessageProcessor>>();
    private final List<AuditMessageProcessor> _globalAuditMessageProcessors = new CopyOnWriteArrayList<AuditMessageProcessor>();
    @Reference
    private MessageBus _messageBus;
    private ServiceRegistration<ProxyMessageListener> _serviceRegistration;

    public boolean isDeployed() {
        int auditMessageProcessorsCount = this._auditMessageProcessors.size();
        return auditMessageProcessorsCount > 0 || !this._globalAuditMessageProcessors.isEmpty();
    }

    public void route(AuditMessage auditMessage) throws AuditException {
        if (!this._auditEnabled) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Audit disabled, not processing message: " + auditMessage));
            }
            return;
        }
        for (AuditMessageProcessor globalAuditMessageProcessor : this._globalAuditMessageProcessors) {
            globalAuditMessageProcessor.process(auditMessage);
        }
        Set<AuditMessageProcessor> auditMessageProcessors = this._auditMessageProcessors.get(auditMessage.getEventType());
        if (auditMessageProcessors != null) {
            for (AuditMessageProcessor auditMessageProcessor : auditMessageProcessors) {
                auditMessageProcessor.process(auditMessage);
            }
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this.modified(properties);
        ProxyMessageListener proxyMessageListener = new ProxyMessageListener();
        proxyMessageListener.setManager((Object)this);
        proxyMessageListener.setMessageBus(this._messageBus);
        this._serviceRegistration = bundleContext.registerService(ProxyMessageListener.class, (Object)proxyMessageListener, (Dictionary)HashMapDictionaryBuilder.put((Object)"destination.name", (Object)"liferay/audit").build());
    }

    @Deactivate
    protected void deactivate() {
        if (this._serviceRegistration != null) {
            this._serviceRegistration.unregister();
        }
    }

    @Modified
    protected void modified(Map<String, Object> properties) {
        AuditConfiguration auditConfiguration = (AuditConfiguration)ConfigurableUtil.createConfigurable(AuditConfiguration.class, properties);
        this._auditEnabled = auditConfiguration.enabled();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setAuditMessageProcessor(AuditMessageProcessor auditMessageProcessor, Map<String, Object> properties) {
        String[] eventTypes = this._getEventTypes(properties);
        if (eventTypes.length == 1 && eventTypes[0].equals("*")) {
            this._globalAuditMessageProcessors.add(auditMessageProcessor);
            return;
        }
        for (String eventType : eventTypes) {
            Set<AuditMessageProcessor> auditMessageProcessorsSet = this._auditMessageProcessors.get(eventType);
            if (auditMessageProcessorsSet == null) {
                auditMessageProcessorsSet = new HashSet<AuditMessageProcessor>();
                this._auditMessageProcessors.put(eventType, auditMessageProcessorsSet);
            }
            auditMessageProcessorsSet.add(auditMessageProcessor);
        }
    }

    protected void unsetAuditMessageProcessor(AuditMessageProcessor auditMessageProcessor, Map<String, Object> properties) {
        String[] eventTypes = this._getEventTypes(properties);
        if (eventTypes.length == 1 && eventTypes[0].equals("*")) {
            this._globalAuditMessageProcessors.remove(auditMessageProcessor);
            return;
        }
        for (String eventType : eventTypes) {
            Set<AuditMessageProcessor> auditMessageProcessorsSet = this._auditMessageProcessors.get(eventType);
            if (auditMessageProcessorsSet == null) continue;
            auditMessageProcessorsSet.remove(auditMessageProcessor);
        }
    }

    private String[] _getEventTypes(Map<String, Object> properties) {
        String eventTypes = (String)properties.get("eventTypes");
        if (Validator.isNull((String)eventTypes)) {
            throw new IllegalArgumentException("The property \"eventTypes\" is null");
        }
        return StringUtil.split((String)eventTypes);
    }
}

