/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.audit.router.internal;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.security.audit.AuditEventManager;
import com.liferay.portal.security.audit.AuditMessageProcessor;
import com.liferay.portal.security.audit.router.configuration.PersistentAuditMessageProcessorConfiguration;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.security.audit.router.configuration.PersistentAuditMessageProcessorConfiguration"}, immediate=true, property={"eventTypes=*"}, service={AuditMessageProcessor.class})
public class PersistentAuditMessageProcessor
implements AuditMessageProcessor {
    private static final Log _log = LogFactoryUtil.getLog(PersistentAuditMessageProcessor.class);
    @Reference
    private AuditEventManager _auditEventManager;
    private volatile boolean _enabled;

    public void process(AuditMessage auditMessage) {
        try {
            this.doProcess(auditMessage);
        }
        catch (Exception e) {
            _log.fatal((Object)("Unable to process audit message " + auditMessage), (Throwable)e);
        }
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        PersistentAuditMessageProcessorConfiguration messageProcessorConfiguration = (PersistentAuditMessageProcessorConfiguration)ConfigurableUtil.createConfigurable(PersistentAuditMessageProcessorConfiguration.class, properties);
        this._enabled = false;
        if (messageProcessorConfiguration != null && messageProcessorConfiguration.enabled()) {
            this._enabled = true;
        }
    }

    protected void doProcess(AuditMessage auditMessage) throws Exception {
        if (!this._enabled) {
            return;
        }
        this._auditEventManager.addAuditEvent(auditMessage);
    }
}

