/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.audit.event.generators.user.management.internal.model.listener;

import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.audit.AuditRouter;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ContactLocalService;
import com.liferay.portal.security.audit.event.generators.util.Attribute;
import com.liferay.portal.security.audit.event.generators.util.AttributesBuilder;
import com.liferay.portal.security.audit.event.generators.util.AuditMessageBuilder;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class ContactModelListener
extends BaseModelListener<Contact> {
    @Reference
    private AuditRouter _auditRouter;
    @Reference
    private ContactLocalService _contactLocalService;

    public void onBeforeUpdate(Contact originalContact, Contact contact) throws ModelListenerException {
        try {
            List<Attribute> attributes = this.getModifiedAttributes(originalContact, contact);
            if (!attributes.isEmpty()) {
                AuditMessage auditMessage = AuditMessageBuilder.buildAuditMessage((String)"UPDATE", (String)User.class.getName(), (long)contact.getClassPK(), attributes);
                this._auditRouter.route(auditMessage);
            }
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }

    protected List<Attribute> getModifiedAttributes(Contact originalContact, Contact contact) {
        AttributesBuilder attributesBuilder = new AttributesBuilder((Object)contact, (Object)originalContact);
        attributesBuilder.add("birthday");
        attributesBuilder.add("employeeNumber");
        attributesBuilder.add("employeeStatusId");
        attributesBuilder.add("facebookSn");
        attributesBuilder.add("firstName");
        attributesBuilder.add("hoursOfOperation");
        attributesBuilder.add("jabberSn");
        attributesBuilder.add("jobClass");
        attributesBuilder.add("jobTitle");
        attributesBuilder.add("lastName");
        attributesBuilder.add("male");
        attributesBuilder.add("middleName");
        attributesBuilder.add("prefixId");
        attributesBuilder.add("skypeSn");
        attributesBuilder.add("smsSn");
        attributesBuilder.add("suffixId");
        attributesBuilder.add("twitterSn");
        return attributesBuilder.getAttributes();
    }
}

