/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.audit.event.generators.user.management.internal.model.listener;

import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.audit.AuditRouter;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.UserGroupLocalService;
import com.liferay.portal.security.audit.event.generators.util.Attribute;
import com.liferay.portal.security.audit.event.generators.util.AttributesBuilder;
import com.liferay.portal.security.audit.event.generators.util.AuditMessageBuilder;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class UserGroupModelListener
extends BaseModelListener<UserGroup> {
    @Reference
    private AuditRouter _auditRouter;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private UserGroupLocalService _userGroupLocalService;

    public void onBeforeAddAssociation(Object classPK, String associationClassName, Object associationClassPK) throws ModelListenerException {
        this.auditOnAddorRemoveAssociation("ASSIGN", classPK, associationClassName, associationClassPK);
    }

    public void onBeforeCreate(UserGroup userGroup) throws ModelListenerException {
        this.auditOnCreateOrRemove("ADD", userGroup);
    }

    public void onBeforeRemove(UserGroup userGroup) throws ModelListenerException {
        this.auditOnCreateOrRemove("DELETE", userGroup);
    }

    public void onBeforeRemoveAssociation(Object classPK, String associationClassName, Object associationClassPK) throws ModelListenerException {
        this.auditOnAddorRemoveAssociation("UNASSIGN", classPK, associationClassName, associationClassPK);
    }

    public void onBeforeUpdate(UserGroup newUserGroup) throws ModelListenerException {
        try {
            UserGroup oldUserGroup = this._userGroupLocalService.getUserGroup(newUserGroup.getUserGroupId());
            List<Attribute> attributes = this.getModifiedAttributes(newUserGroup, oldUserGroup);
            if (!attributes.isEmpty()) {
                AuditMessage auditMessage = AuditMessageBuilder.buildAuditMessage((String)"UPDATE", (String)UserGroup.class.getName(), (long)newUserGroup.getUserGroupId(), attributes);
                this._auditRouter.route(auditMessage);
            }
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }

    protected void auditOnAddorRemoveAssociation(String eventType, Object classPK, String associationClassName, Object associationClassPK) throws ModelListenerException {
        if (!associationClassName.equals(Group.class.getName()) && !associationClassName.equals(User.class.getName())) {
            return;
        }
        try {
            AuditMessage auditMessage = null;
            if (associationClassName.equals(Group.class.getName())) {
                long groupId = (Long)associationClassPK;
                Group group = this._groupLocalService.getGroup(groupId);
                auditMessage = AuditMessageBuilder.buildAuditMessage((String)eventType, (String)group.getClassName(), (long)group.getClassPK(), null);
            } else {
                auditMessage = AuditMessageBuilder.buildAuditMessage((String)eventType, (String)associationClassName, (long)((Long)associationClassPK), null);
            }
            JSONObject additionalInfoJSONObject = auditMessage.getAdditionalInfo();
            long userGroupId = (Long)classPK;
            additionalInfoJSONObject.put("userGroupId", userGroupId);
            UserGroup userGroup = this._userGroupLocalService.getUserGroup(userGroupId);
            additionalInfoJSONObject.put("userGroupName", userGroup.getName());
            this._auditRouter.route(auditMessage);
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }

    protected void auditOnCreateOrRemove(String eventType, UserGroup userGroup) throws ModelListenerException {
        try {
            AuditMessage auditMessage = AuditMessageBuilder.buildAuditMessage((String)eventType, (String)UserGroup.class.getName(), (long)userGroup.getUserGroupId(), null);
            this._auditRouter.route(auditMessage);
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }

    protected List<Attribute> getModifiedAttributes(UserGroup newUserGroup, UserGroup oldUserGroup) {
        AttributesBuilder attributesBuilder = new AttributesBuilder((Object)newUserGroup, (Object)oldUserGroup);
        attributesBuilder.add("description");
        attributesBuilder.add("name");
        return attributesBuilder.getAttributes();
    }
}

