/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.audit.event.generators.user.management.internal.model.listener;

import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.audit.AuditRouter;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.security.audit.event.generators.util.Attribute;
import com.liferay.portal.security.audit.event.generators.util.AttributesBuilder;
import com.liferay.portal.security.audit.event.generators.util.AuditMessageBuilder;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class UserModelListener
extends BaseModelListener<User> {
    @Reference
    private AuditRouter _auditRouter;
    @Reference
    private UserLocalService _userLocalService;

    public void onBeforeCreate(User user) throws ModelListenerException {
        this.auditOnCreateOrRemove("ADD", user);
    }

    public void onBeforeRemove(User user) throws ModelListenerException {
        this.auditOnCreateOrRemove("DELETE", user);
    }

    public void onBeforeUpdate(User newUser) throws ModelListenerException {
        try {
            User oldUser = this._userLocalService.getUser(newUser.getUserId());
            List<Attribute> attributes = this.getModifiedAttributes(newUser, oldUser);
            if (!attributes.isEmpty()) {
                AuditMessage auditMessage = AuditMessageBuilder.buildAuditMessage((String)"UPDATE", (String)User.class.getName(), (long)newUser.getUserId(), attributes);
                this._auditRouter.route(auditMessage);
            }
        }
        catch (Exception e) {
            throw new ModelListenerException((Throwable)e);
        }
    }

    protected void auditOnCreateOrRemove(String eventType, User user) throws ModelListenerException {
        try {
            AuditMessage auditMessage = AuditMessageBuilder.buildAuditMessage((String)eventType, (String)User.class.getName(), (long)user.getUserId(), null);
            JSONObject additionalInfoJSONObject = auditMessage.getAdditionalInfo();
            additionalInfoJSONObject.put("emailAddress", user.getEmailAddress());
            additionalInfoJSONObject.put("screenName", user.getScreenName());
            additionalInfoJSONObject.put("userId", user.getUserId());
            additionalInfoJSONObject.put("userName", user.getFullName());
            this._auditRouter.route(auditMessage);
        }
        catch (Exception e) {
            throw new ModelListenerException((Throwable)e);
        }
    }

    protected List<Attribute> getModifiedAttributes(User newUser, User oldUser) {
        AttributesBuilder attributesBuilder = new AttributesBuilder((Object)newUser, (Object)oldUser);
        attributesBuilder.add("active");
        attributesBuilder.add("agreedToTermsOfUse");
        attributesBuilder.add("comments");
        attributesBuilder.add("emailAddress");
        attributesBuilder.add("languageId");
        attributesBuilder.add("reminderQueryAnswer");
        attributesBuilder.add("reminderQueryQuestion");
        attributesBuilder.add("screenName");
        attributesBuilder.add("timeZoneId");
        List attributes = attributesBuilder.getAttributes();
        if (newUser.isPasswordModified()) {
            attributes.add(new Attribute("password"));
        }
        return attributes;
    }
}

