/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.audit.event.generators.user.management.internal.model.listener;

import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.audit.AuditRouter;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.security.audit.event.generators.util.Attribute;
import com.liferay.portal.security.audit.event.generators.util.AttributesBuilder;
import com.liferay.portal.security.audit.event.generators.util.AuditMessageBuilder;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class OrganizationModelListener
extends BaseModelListener<Organization> {
    @Reference
    private AuditRouter _auditRouter;
    @Reference
    private OrganizationLocalService _organizationLocalService;

    public void onBeforeAddAssociation(Object classPK, String associationClassName, Object associationClassPK) throws ModelListenerException {
        this.auditOnAddorRemoveAssociation("ASSIGN", classPK, associationClassName, associationClassPK);
    }

    public void onBeforeCreate(Organization organization) throws ModelListenerException {
        this.auditOnCreateOrRemove("ADD", organization);
    }

    public void onBeforeRemove(Organization organization) throws ModelListenerException {
        this.auditOnCreateOrRemove("DELETE", organization);
    }

    public void onBeforeRemoveAssociation(Object classPK, String associationClassName, Object associationClassPK) throws ModelListenerException {
        this.auditOnAddorRemoveAssociation("UNASSIGN", classPK, associationClassName, associationClassPK);
    }

    public void onBeforeUpdate(Organization newOrganization) throws ModelListenerException {
        try {
            Organization oldOrganization = this._organizationLocalService.getOrganization(newOrganization.getOrganizationId());
            List<Attribute> attributes = this.getModifiedAttributes(newOrganization, oldOrganization);
            if (!attributes.isEmpty()) {
                AuditMessage auditMessage = AuditMessageBuilder.buildAuditMessage((String)"UPDATE", (String)Organization.class.getName(), (long)newOrganization.getOrganizationId(), attributes);
                this._auditRouter.route(auditMessage);
            }
        }
        catch (Exception e) {
            throw new ModelListenerException((Throwable)e);
        }
    }

    protected void auditOnAddorRemoveAssociation(String eventType, Object classPK, String associationClassName, Object associationClassPK) throws ModelListenerException {
        if (!associationClassName.equals(User.class.getName())) {
            return;
        }
        try {
            AuditMessage auditMessage = AuditMessageBuilder.buildAuditMessage((String)eventType, (String)associationClassName, (long)((Long)associationClassPK), null);
            JSONObject additionalInfoJSONObject = auditMessage.getAdditionalInfo();
            long organizationId = (Long)classPK;
            additionalInfoJSONObject.put("organizationId", organizationId);
            Organization organization = this._organizationLocalService.getOrganization(organizationId);
            additionalInfoJSONObject.put("organizationName", organization.getName());
            this._auditRouter.route(auditMessage);
        }
        catch (Exception e) {
            throw new ModelListenerException((Throwable)e);
        }
    }

    protected void auditOnCreateOrRemove(String eventType, Organization organization) throws ModelListenerException {
        try {
            AuditMessage auditMessage = AuditMessageBuilder.buildAuditMessage((String)eventType, (String)Organization.class.getName(), (long)organization.getOrganizationId(), null);
            this._auditRouter.route(auditMessage);
        }
        catch (Exception e) {
            throw new ModelListenerException((Throwable)e);
        }
    }

    protected List<Attribute> getModifiedAttributes(Organization newOrganization, Organization oldOrganization) {
        AttributesBuilder attributesBuilder = new AttributesBuilder((Object)newOrganization, (Object)oldOrganization);
        attributesBuilder.add("comments");
        attributesBuilder.add("countryId");
        attributesBuilder.add("name");
        attributesBuilder.add("parentOrganizationId");
        attributesBuilder.add("regionId");
        return attributesBuilder.getAttributes();
    }
}

