/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.antisamy.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.sanitizer.BaseSanitizer;
import com.liferay.portal.kernel.sanitizer.SanitizerException;
import com.liferay.portal.kernel.util.Validator;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.owasp.validator.html.AntiSamy;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;

public class AntiSamySanitizerImpl
extends BaseSanitizer {
    private static final Log _log = LogFactoryUtil.getLog(AntiSamySanitizerImpl.class);
    private final List<String> _blacklist = new ArrayList<String>();
    private final Policy _policy;
    private final List<String> _whitelist = new ArrayList<String>();

    public AntiSamySanitizerImpl(String[] blacklist, URL url, String[] whitelist) {
        try (InputStream inputstream = url.openStream();){
            this._policy = Policy.getInstance((InputStream)inputstream);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to initialize policy", e);
        }
        if (blacklist != null) {
            for (String blacklistItem : blacklist) {
                if ((blacklistItem = blacklistItem.trim()).isEmpty()) continue;
                blacklistItem = this.stripTrailingStar(blacklistItem);
                this._blacklist.add(blacklistItem);
            }
        }
        if (whitelist != null) {
            for (String whitelistItem : whitelist) {
                if ((whitelistItem = whitelistItem.trim()).isEmpty()) continue;
                whitelistItem = this.stripTrailingStar(whitelistItem);
                this._whitelist.add(whitelistItem);
            }
        }
    }

    public String sanitize(long companyId, long groupId, long userId, String className, long classPK, String contentType, String[] modes, String content, Map<String, Object> options) throws SanitizerException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Sanitizing ", className, "#", classPK}));
        }
        if (Validator.isNull((String)content)) {
            return content;
        }
        if (Validator.isNull((String)contentType) || !contentType.equals("text/html")) {
            return content;
        }
        if (this.isWhitelisted(className, classPK)) {
            return content;
        }
        try {
            AntiSamy antiSamy = new AntiSamy();
            CleanResults cleanResults = antiSamy.scan(content, this._policy);
            return cleanResults.getCleanHTML();
        }
        catch (Exception e) {
            _log.error((Object)"Unable to sanitize input", (Throwable)e);
            throw new SanitizerException((Throwable)e);
        }
    }

    protected boolean isWhitelisted(String className, long classPK) {
        String classNameAndClassPK = className + "#" + classPK;
        for (String blacklistItem : this._blacklist) {
            if (!blacklistItem.equals("*") && !classNameAndClassPK.startsWith(blacklistItem)) continue;
            return false;
        }
        for (String whitelistItem : this._whitelist) {
            if (!whitelistItem.equals("*") && !classNameAndClassPK.startsWith(whitelistItem)) continue;
            return true;
        }
        return false;
    }

    protected String stripTrailingStar(String item) {
        if (item.equals("*")) {
            return item;
        }
        char c = item.charAt(item.length() - 1);
        if (c == '*') {
            return item.substring(0, item.length() - 1);
        }
        return item;
    }
}

