/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.antisamy.internal;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.sanitizer.Sanitizer;
import com.liferay.portal.security.antisamy.configuration.AntiSamyConfiguration;
import com.liferay.portal.security.antisamy.internal.AntiSamySanitizerImpl;
import java.net.URL;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"com.liferay.portal.security.antisamy.configuration.AntiSamyConfiguration"}, immediate=true)
public class AntiSamySanitizerPublisher {
    private ServiceRegistration<Sanitizer> _sanitizerServiceRegistration;

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        AntiSamyConfiguration antiSamyConfiguration = (AntiSamyConfiguration)ConfigurableUtil.createConfigurable(AntiSamyConfiguration.class, properties);
        if (!antiSamyConfiguration.enabled()) {
            return;
        }
        Bundle bundle = bundleContext.getBundle();
        URL url = bundle.getResource(antiSamyConfiguration.configurationFileURL());
        if (url == null) {
            throw new IllegalStateException("Unable to find " + antiSamyConfiguration.configurationFileURL());
        }
        AntiSamySanitizerImpl sanitizer = new AntiSamySanitizerImpl(antiSamyConfiguration.blacklist(), url, antiSamyConfiguration.whitelist());
        this._sanitizerServiceRegistration = bundleContext.registerService(Sanitizer.class, (Object)sanitizer, null);
    }

    @Deactivate
    protected void deactivate() {
        if (this._sanitizerServiceRegistration != null) {
            this._sanitizerServiceRegistration.unregister();
            this._sanitizerServiceRegistration = null;
        }
    }

    @Modified
    protected void modified(BundleContext bundleContext, Map<String, Object> properties) {
        this.deactivate();
        this.activate(bundleContext, properties);
    }
}

