/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.upgrade.v1_0_1;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.PrefsProps;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.configuration.ReindexConfiguration;
import java.util.Dictionary;
import java.util.Objects;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class ReindexConfigurationUpgradeProcess
extends UpgradeProcess {
    private static final int _DL_FILE_INDEXING_INTERVAL = 500;
    private final ConfigurationAdmin _configurationAdmin;
    private final PrefsProps _prefsProps;

    public ReindexConfigurationUpgradeProcess(ConfigurationAdmin configurationAdmin, PrefsProps prefsProps) {
        this._configurationAdmin = configurationAdmin;
        this._prefsProps = prefsProps;
    }

    protected void doUpgrade() throws Exception {
        String filterString = StringBundler.concat((String[])new String[]{"(", "service.pid", "=", ReindexConfiguration.class.getName(), ")"});
        Object[] configurations = this._configurationAdmin.listConfigurations(filterString);
        int interval = this._prefsProps.getInteger("dl.file.indexing.interval", 500);
        if (ArrayUtil.isEmpty((Object[])configurations) && interval != 500) {
            this._addNewConfiguration(interval);
        } else if (ArrayUtil.isNotEmpty((Object[])configurations)) {
            for (Object configuration : configurations) {
                this._upgradeExistingConfiguration((Configuration)configuration, interval);
            }
        }
    }

    private void _addNewConfiguration(int interval) throws Exception {
        Configuration configuration = this._configurationAdmin.getConfiguration(ReindexConfiguration.class.getName(), "?");
        configuration.update((Dictionary)HashMapDictionaryBuilder.put((Object)"indexingBatchSizes", (Object)new String[]{StringBundler.concat((Object[])new Object[]{DLFileEntry.class.getName(), "=", interval})}).build());
    }

    private boolean _isDLFileEntryConfigurationEntry(String value) {
        String[] valueParts = StringUtil.split((String)value, (String)"=");
        return valueParts.length == 2 && Objects.equals(valueParts[0], DLFileEntry.class.getName());
    }

    private void _upgradeExistingConfiguration(Configuration configuration, int interval) throws Exception {
        Object[] values;
        Dictionary properties = configuration.getProperties();
        for (String string : values = GetterUtil.getStringValues(properties.get("indexingBatchSizes"))) {
            if (!this._isDLFileEntryConfigurationEntry(string)) continue;
            return;
        }
        properties.put("indexingBatchSizes", ArrayUtil.append((Object[])values, (Object)(DLFileEntry.class.getName() + "=" + interval)));
        configuration.update(properties);
    }
}

