/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.spi.model.query.contributor;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.search.query.QueryHelper;
import com.liferay.portal.search.spi.model.query.contributor.KeywordQueryContributor;
import com.liferay.portal.search.spi.model.query.contributor.helper.KeywordQueryContributorHelper;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={KeywordQueryContributor.class})
public class AssetTagNamesKeywordQueryContributor
implements KeywordQueryContributor {
    @Reference
    private Localization _localization;
    @Reference
    private Portal _portal;
    @Reference
    private QueryHelper _queryHelper;

    public void contribute(String keywords, BooleanQuery booleanQuery, KeywordQueryContributorHelper keywordQueryContributorHelper) {
        SearchContext searchContext = keywordQueryContributorHelper.getSearchContext();
        Locale locale = this._getLocale(searchContext);
        this._queryHelper.addSearchTerm(booleanQuery, searchContext, this._localization.getLocalizedName("assetTagNames", LocaleUtil.toLanguageId((Locale)locale)), false);
    }

    private long _getGroupId(SearchContext searchContext) {
        Layout layout = searchContext.getLayout();
        if (layout != null) {
            return layout.getGroupId();
        }
        long[] groupIds = searchContext.getGroupIds();
        if (ArrayUtil.isNotEmpty((long[])groupIds)) {
            return GetterUtil.getLong((Object)groupIds[0]);
        }
        return 0L;
    }

    private Locale _getLocale(SearchContext searchContext) {
        long groupId = this._getGroupId(searchContext);
        if (groupId > 0L) {
            return this._getSiteDefaultLocale(groupId);
        }
        return searchContext.getLocale();
    }

    private Locale _getSiteDefaultLocale(long groupId) {
        try {
            return this._portal.getSiteDefaultLocale(groupId);
        }
        catch (PortalException portalException) {
            throw new RuntimeException(portalException);
        }
    }
}

