/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.spi.model.query.contributor;

import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.search.spi.model.query.contributor.QueryPreFilterContributor;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={QueryPreFilterContributor.class})
public class AssetCategoryIdsQueryPreFilterContributor
implements QueryPreFilterContributor {
    public void contribute(BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) {
        long[] assetCategoryIds = searchContext.getAssetCategoryIds();
        if (ArrayUtil.isEmpty((long[])assetCategoryIds)) {
            return;
        }
        TermsFilter categoryIdsTermsFilter = new TermsFilter("assetCategoryIds");
        categoryIdsTermsFilter.addValues(ArrayUtil.toStringArray((long[])assetCategoryIds));
        if (!searchContext.isIncludeInternalAssetCategories()) {
            fullQueryBooleanFilter.add((Filter)categoryIdsTermsFilter, BooleanClauseOccur.MUST);
            return;
        }
        BooleanFilter booleanFilter = new BooleanFilter();
        TermsFilter internalCategoryIdsTermsFilter = new TermsFilter("assetInternalCategoryIds");
        internalCategoryIdsTermsFilter.addValues(ArrayUtil.toStringArray((long[])assetCategoryIds));
        booleanFilter.add((Filter)categoryIdsTermsFilter);
        booleanFilter.add((Filter)internalCategoryIdsTermsFilter);
        fullQueryBooleanFilter.add((Filter)booleanFilter, BooleanClauseOccur.MUST);
    }
}

