/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.sort;

import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapperFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.search.contributor.sort.SortFieldNameTranslator;
import com.liferay.portal.search.sort.SortFieldBuilder;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={SortFieldBuilder.class})
public class SortFieldBuilderImpl
implements SortFieldBuilder {
    private Set<String> _defaultSortableTextFields;
    @Reference
    private IndexerRegistry _indexerRegistry;
    @Reference
    private Props _props;
    private ServiceTrackerMap<Class<?>, SortFieldNameTranslator> _serviceTrackerMap;

    public String getSortField(Class<?> entityClass, String orderByCol) {
        String sortField = this._getSortField(entityClass, orderByCol);
        if (this._defaultSortableTextFields.contains(sortField)) {
            return Field.getSortableFieldName((String)sortField);
        }
        return sortField;
    }

    public String getSortField(Class<?> entityClass, String orderByCol, int sortType) {
        if (sortType == 7 || sortType == 5 || sortType == 4 || sortType == 6) {
            return Field.getSortableFieldName((String)orderByCol);
        }
        return this.getSortField(entityClass, orderByCol);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._defaultSortableTextFields = SetUtil.fromArray((Object[])this._props.getArray("index.sortable.text.fields"));
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, SortFieldNameTranslator.class, null, (ServiceReferenceMapper)ServiceReferenceMapperFactory.create((BundleContext)bundleContext, (sortFieldNameTranslator, emitter) -> emitter.emit((Object)sortFieldNameTranslator.getEntityClass())));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    private String _getSortField(Class<?> entityClass, String orderByCol) {
        SortFieldNameTranslator sortFieldNameTranslator = (SortFieldNameTranslator)this._serviceTrackerMap.getService(entityClass);
        if (sortFieldNameTranslator == null) {
            Indexer indexer = this._indexerRegistry.getIndexer(entityClass);
            return indexer.getSortField(orderByCol);
        }
        return sortFieldNameTranslator.getSortFieldName(orderByCol);
    }
}

