/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.sort;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.sort.Sort;
import com.liferay.portal.search.sort.SortBuilder;
import com.liferay.portal.search.sort.SortOrder;
import com.liferay.portal.search.sort.Sorts;
import java.util.Locale;

public class SortBuilderImpl
implements SortBuilder {
    private String _field;
    private Locale _locale;
    private Localization _localization;
    private SortOrder _sortOrder;
    private final Sorts _sorts;

    public SortBuilderImpl(Sorts sorts) {
        this._sorts = sorts;
    }

    public Sort build() {
        if (!Validator.isBlank((String)this._field)) {
            return this._sorts.field(this._getSortableField(), this._sortOrder);
        }
        throw new UnsupportedOperationException();
    }

    public SortBuilder field(String field) {
        this._field = field;
        return this;
    }

    public SortBuilder locale(Locale locale) {
        this._locale = locale;
        return this;
    }

    public SortBuilder sortOrder(SortOrder sortOrder) {
        this._sortOrder = sortOrder;
        return this;
    }

    private Localization _getLocalization() {
        if (this._localization != null) {
            return this._localization;
        }
        return LocalizationUtil.getLocalization();
    }

    private String _getLocalizedName(String name, Locale locale) {
        Localization localization = this._getLocalization();
        return localization.getLocalizedName(name, LocaleUtil.toLanguageId((Locale)locale));
    }

    private String _getSortableField() {
        if (this._locale != null && this._field.equals("title")) {
            return StringBundler.concat((String[])new String[]{"localized_", this._getLocalizedName(this._field, this._locale), "_sortable"});
        }
        return this._field;
    }
}

