/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.searcher.helper;

import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.search.internal.searcher.helper.IndexSearcherHelper;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={IndexSearcherHelper.class})
public class IndexSearcherHelperImpl
implements IndexSearcherHelper {
    @Reference
    private com.liferay.portal.kernel.search.IndexSearcherHelper _indexSearcherHelper;

    @Override
    public String getQueryString(SearchContext searchContext, Query query) {
        return this._indexSearcherHelper.getQueryString(searchContext, query);
    }

    @Override
    public Hits search(SearchContext searchContext, Query query) {
        try {
            return this._indexSearcherHelper.search(searchContext, query);
        }
        catch (SearchException searchException) {
            throw this._uncheck(searchException);
        }
    }

    @Override
    public long searchCount(SearchContext searchContext, Query query) {
        try {
            return this._indexSearcherHelper.searchCount(searchContext, query);
        }
        catch (SearchException searchException) {
            throw this._uncheck(searchException);
        }
    }

    @Override
    public String spellCheckKeywords(SearchContext searchContext) {
        try {
            return this._indexSearcherHelper.spellCheckKeywords(searchContext);
        }
        catch (SearchException searchException) {
            throw this._uncheck(searchException);
        }
    }

    @Override
    public Map<String, List<String>> spellCheckKeywords(SearchContext searchContext, int max) {
        try {
            return this._indexSearcherHelper.spellCheckKeywords(searchContext, max);
        }
        catch (SearchException searchException) {
            throw this._uncheck(searchException);
        }
    }

    @Override
    public String[] suggestKeywordQueries(SearchContext searchContext, int max) {
        try {
            return this._indexSearcherHelper.suggestKeywordQueries(searchContext, max);
        }
        catch (SearchException searchException) {
            throw this._uncheck(searchException);
        }
    }

    private RuntimeException _uncheck(SearchException searchException) {
        if (searchException.getCause() instanceof RuntimeException) {
            return (RuntimeException)searchException.getCause();
        }
        if (searchException.getCause() != null) {
            return new RuntimeException(searchException.getCause());
        }
        return new RuntimeException(searchException);
    }
}

