/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.searcher;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.search.internal.searcher.SearchRequestContributorsRegistry;
import com.liferay.portal.search.spi.searcher.SearchRequestContributor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={SearchRequestContributorsRegistry.class})
public class SearchRequestContributorsRegistryImpl
implements SearchRequestContributorsRegistry {
    private final Collection<SearchRequestContributor> _searchRequestContributors = new CopyOnWriteArrayList<SearchRequestContributor>();
    private ServiceTrackerMap<String, List<SearchRequestContributor>> _serviceTrackerMap;

    @Override
    public Stream<SearchRequestContributor> stream() {
        return this._searchRequestContributors.stream();
    }

    @Override
    public Stream<SearchRequestContributor> stream(Collection<String> includeIds, Collection<String> excludeIds) {
        Collection<SearchRequestContributor> collection = this._include(includeIds);
        this._exclude(collection, excludeIds);
        return collection.stream();
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)bundleContext, SearchRequestContributor.class, (String)"search.request.contributor.id");
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addSearchRequestContributor(SearchRequestContributor searchRequestContributor) {
        this._searchRequestContributors.add(searchRequestContributor);
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    protected void removeSearchRequestContributor(SearchRequestContributor searchRequestContributor) {
        this._searchRequestContributors.remove(searchRequestContributor);
    }

    private void _exclude(Collection<SearchRequestContributor> collection, Collection<String> ids) {
        for (String id : ids) {
            List searchRequestContributors = (List)this._serviceTrackerMap.getService((Object)id);
            if (!Objects.nonNull(searchRequestContributors)) continue;
            collection.removeAll(searchRequestContributors);
        }
    }

    private Collection<SearchRequestContributor> _include(Collection<String> ids) {
        if (ids == null || ids.isEmpty()) {
            return new ArrayList<SearchRequestContributor>(this._searchRequestContributors);
        }
        ArrayList<SearchRequestContributor> collection = new ArrayList<SearchRequestContributor>();
        for (String id : ids) {
            collection.addAll((Collection)this._serviceTrackerMap.getService((Object)id));
        }
        return collection;
    }
}

