/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.script;

import com.liferay.portal.search.script.Script;
import com.liferay.portal.search.script.ScriptBuilder;
import com.liferay.portal.search.script.ScriptType;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class ScriptImpl
implements Script {
    private String _idOrCode;
    private String _language;
    private final Map<String, String> _options = new LinkedHashMap<String, String>();
    private final Map<String, Object> _parameters = new LinkedHashMap<String, Object>();
    private ScriptType _scriptType;

    public String getIdOrCode() {
        return this._idOrCode;
    }

    public String getLanguage() {
        return this._language;
    }

    public Map<String, String> getOptions() {
        return Collections.unmodifiableMap(this._options);
    }

    public Map<String, Object> getParameters() {
        return Collections.unmodifiableMap(this._parameters);
    }

    public ScriptType getScriptType() {
        return this._scriptType;
    }

    protected ScriptImpl() {
    }

    protected ScriptImpl(ScriptImpl scriptImpl) {
        this._idOrCode = scriptImpl._idOrCode;
        this._language = scriptImpl._language;
        this._scriptType = scriptImpl._scriptType;
        this._options.putAll(scriptImpl._options);
        this._parameters.putAll(scriptImpl._parameters);
    }

    public static final class ScriptBuilderImpl
    implements ScriptBuilder {
        private final ScriptImpl _scriptImpl = new ScriptImpl();

        public Script build() {
            return new ScriptImpl(this._scriptImpl);
        }

        public ScriptBuilder idOrCode(String idOrCode) {
            this._scriptImpl._idOrCode = idOrCode;
            return this;
        }

        public ScriptBuilder language(String language) {
            this._scriptImpl._language = language;
            return this;
        }

        public ScriptBuilder options(Map<String, String> optionsMap) {
            this._scriptImpl._options.clear();
            this._scriptImpl._options.putAll(optionsMap);
            return this;
        }

        public ScriptBuilder parameters(Map<String, Object> parametersMap) {
            this._scriptImpl._parameters.clear();
            this._scriptImpl._parameters.putAll(parametersMap);
            return this;
        }

        public ScriptBuilder putOption(String optionName, String optionValue) {
            this._scriptImpl._options.put(optionName, optionValue);
            return this;
        }

        public ScriptBuilder putParameter(String parameterName, Object parameterValue) {
            this._scriptImpl._parameters.put(parameterName, parameterValue);
            return this;
        }

        public ScriptBuilder scriptType(ScriptType scriptType) {
            this._scriptImpl._scriptType = scriptType;
            return this;
        }
    }
}

