/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.result;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.SummaryFactory;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={SummaryFactory.class})
public class SummaryFactoryImpl
implements SummaryFactory {
    public static final int SUMMARY_MAX_CONTENT_LENGTH = 200;
    @Reference
    private IndexerRegistry _indexerRegistry;

    public Summary getSummary(Document document, String className, long classPK, Locale locale, PortletRequest portletRequest, PortletResponse portletResponse) throws PortalException {
        Indexer indexer = this._indexerRegistry.getIndexer(className);
        if (indexer != null) {
            String snippet = document.get("snippet");
            return indexer.getSummary(document, snippet, portletRequest, portletResponse);
        }
        return this.getSummary(className, classPK, locale);
    }

    public Summary getSummary(String className, long classPK, Locale locale) throws PortalException {
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)className);
        if (assetRendererFactory == null) {
            return null;
        }
        AssetRenderer assetRenderer = assetRendererFactory.getAssetRenderer(classPK);
        if (assetRenderer == null) {
            return null;
        }
        Summary summary = new Summary(assetRenderer.getTitle(locale), assetRenderer.getSearchSummary(locale));
        summary.setMaxContentLength(200);
        return summary;
    }
}

