/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.result;

import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapperFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.SearchResult;
import com.liferay.portal.kernel.search.SearchResultManager;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.SummaryFactory;
import com.liferay.portal.kernel.search.result.SearchResultContributor;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={SearchResultManager.class})
public class SearchResultManagerImpl
implements SearchResultManager {
    @Reference
    private ClassNameLocalService _classNameLocalService;
    private ServiceTrackerMap<String, SearchResultContributor> _serviceTrackerMap;
    @Reference
    private SummaryFactory _summaryFactory;

    public SearchResult createSearchResult(Document document) throws PortalException {
        SearchResultContributor searchResultContributor = this._getSearchResultContributor(document);
        if (searchResultContributor == null) {
            return this._createSearchResultWithEntryClass(document);
        }
        if (this._isClassPresent(document)) {
            return this._createSearchResultWithClass(document);
        }
        return this._createSearchResultWithEntryClass(document);
    }

    public void updateSearchResult(SearchResult searchResult, Document document, Locale locale, PortletRequest portletRequest, PortletResponse portletResponse) throws PortalException {
        SearchResultContributor searchResultContributor = this._getSearchResultContributor(document);
        if (searchResultContributor != null && this._isClassPresent(document)) {
            searchResultContributor.addRelatedModel(searchResult, document, locale, portletRequest, portletResponse);
            if (searchResult.getSummary() == null) {
                searchResult.setSummary(this._getSummaryWithClass(searchResult, locale));
            }
            return;
        }
        searchResult.setSummary(this._getSummaryWithEntryClass(document, locale, portletRequest, portletResponse));
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, SearchResultContributor.class, null, (ServiceReferenceMapper)ServiceReferenceMapperFactory.create((BundleContext)bundleContext, (searchResultContributor, emitter) -> emitter.emit((Object)searchResultContributor.getEntryClassName())));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    private SearchResult _createSearchResultWithClass(Document document) throws PortalException {
        long classNameId = GetterUtil.getLong((String)document.get("classNameId"));
        ClassName className = this._classNameLocalService.getClassName(classNameId);
        if (className == null) {
            throw new PortalException("Unable to get class name from class name ID " + classNameId);
        }
        long classPK = GetterUtil.getLong((String)document.get("classPK"));
        return new SearchResult(className.getClassName(), classPK);
    }

    private SearchResult _createSearchResultWithEntryClass(Document document) {
        String entryClassName = GetterUtil.getString((String)document.get("entryClassName"));
        long entryClassPK = GetterUtil.getLong((String)document.get("entryClassPK"));
        return new SearchResult(entryClassName, entryClassPK);
    }

    private SearchResultContributor _getSearchResultContributor(Document document) {
        String entryClassName = GetterUtil.getString((String)document.get("entryClassName"));
        return (SearchResultContributor)this._serviceTrackerMap.getService((Object)entryClassName);
    }

    private Summary _getSummaryWithClass(SearchResult searchResult, Locale locale) throws PortalException {
        return this._summaryFactory.getSummary(searchResult.getClassName(), searchResult.getClassPK(), locale);
    }

    private Summary _getSummaryWithEntryClass(Document document, Locale locale, PortletRequest portletRequest, PortletResponse portletResponse) throws PortalException {
        String entryClassName = GetterUtil.getString((String)document.get("entryClassName"));
        long entryClassPK = GetterUtil.getLong((String)document.get("entryClassPK"));
        return this._summaryFactory.getSummary(document, entryClassName, entryClassPK, locale, portletRequest, portletResponse);
    }

    private boolean _isClassPresent(Document document) {
        long classNameId = GetterUtil.getLong((String)document.get("classNameId"));
        long classPK = GetterUtil.getLong((String)document.get("classPK"));
        return classNameId > 0L && classPK > 0L;
    }
}

