/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.reindexer;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.search.internal.reindexer.BulkReindexersRegistry;
import com.liferay.portal.search.internal.reindexer.ReindexRequestsHolder;
import com.liferay.portal.search.spi.reindexer.BulkReindexer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;

public class Reindex {
    private static final Log _log = LogFactoryUtil.getLog(Reindex.class);
    private final BulkReindexersRegistry _bulkReindexersRegistry;
    private long _companyId;
    private CustomReindex _customReindex;
    private CustomReindexBulk _customReindexBulk;
    private final ExecutorService _executorService;
    private final IndexerRegistry _indexerRegistry;
    private boolean _nonbulkIndexing;
    private final List<ReindexEndListener> _reindexEndListeners = new ArrayList<ReindexEndListener>();
    private final ReindexRequestsHolder _reindexRequestsHolder;
    private boolean _synchronousExecution;

    public Reindex(IndexerRegistry indexerRegistry, BulkReindexersRegistry bulkReindexersRegistry, ExecutorService executorService, ReindexRequestsHolder reindexRequestsHolder) {
        this._indexerRegistry = indexerRegistry;
        this._bulkReindexersRegistry = bulkReindexersRegistry;
        this._executorService = executorService;
        this._reindexRequestsHolder = reindexRequestsHolder;
    }

    public void reindex(final String className, long ... classPKs) {
        if (this._synchronousExecution) {
            this._reindex(className, ListUtil.fromArray((long[])classPKs));
            return;
        }
        this._reindexRequestsHolder.addAll(className, classPKs);
        this._executorService.submit(new Runnable(){

            @Override
            public void run() {
                Collection<Long> classPKs = Reindex.this._reindexRequestsHolder.drain(className);
                if (!classPKs.isEmpty()) {
                    Reindex.this._reindex(className, classPKs);
                    Reindex.this._executorService.submit(this);
                }
            }
        });
    }

    public void setCompanyId(long companyId) {
        this._companyId = companyId;
    }

    public void setNonbulkIndexing(boolean nonbulkIndexing) {
        this._nonbulkIndexing = nonbulkIndexing;
    }

    public void setSynchronousExecution(boolean synchronousExecution) {
        this._synchronousExecution = synchronousExecution;
    }

    protected void addReindexEndListener(ReindexEndListener reindexEndListener) {
        this._reindexEndListeners.add(reindexEndListener);
    }

    protected Indexer<Object> getIndexer(String className) {
        return this._indexerRegistry.getIndexer(className);
    }

    protected void setCustomReindex(CustomReindex customReindex) {
        this._customReindex = customReindex;
    }

    protected void setCustomReindexBulk(CustomReindexBulk customReindexBulk) {
        this._customReindexBulk = customReindexBulk;
    }

    private void _defaultReindex(String className, long classPK) {
        Indexer<Object> indexer = this.getIndexer(className);
        if (!indexer.isIndexerEnabled()) {
            return;
        }
        try {
            indexer.reindex(className, classPK);
        }
        catch (SearchException searchException) {
            _log.error((Throwable)searchException);
        }
    }

    private void _defaultReindexBulk(String className, Collection<Long> classPKs) {
        Indexer<Object> indexer = this.getIndexer(className);
        if (!indexer.isIndexerEnabled()) {
            return;
        }
        BulkReindexer bulkReindexer = this._bulkReindexersRegistry.getBulkReindexer(className);
        bulkReindexer.reindex(this._companyId, classPKs);
    }

    private void _reindex(String className, Collection<Long> classPKs) {
        if (this._nonbulkIndexing || classPKs.size() < 2) {
            for (long classPK : classPKs) {
                this._reindex(className, classPK);
            }
        } else {
            this._reindexBulk(className, classPKs);
        }
        this._reindexEndListeners.forEach(ReindexEndListener::onReindexEnd);
    }

    private void _reindex(String className, long classPK) {
        if (this._customReindex != null) {
            this._customReindex.reindex(classPK);
        } else {
            this._defaultReindex(className, classPK);
        }
    }

    private void _reindexBulk(String className, Collection<Long> classPKs) {
        if (this._customReindexBulk != null) {
            this._customReindexBulk.reindex(classPKs);
        } else {
            this._defaultReindexBulk(className, classPKs);
        }
    }

    protected static interface ReindexEndListener {
        public void onReindexEnd();
    }

    protected static interface CustomReindexBulk {
        public void reindex(Collection<Long> var1);
    }

    protected static interface CustomReindex {
        public void reindex(long var1);
    }
}

