/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.query.util;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.query.BooleanQuery;
import com.liferay.portal.search.query.Queries;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.query.RangeTermQuery;
import com.liferay.portal.search.query.TermQuery;
import com.liferay.portal.search.query.field.FieldQueryFactory;
import com.liferay.portal.search.query.util.BooleanQueryUtilities;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={BooleanQueryUtilities.class})
public class BooleanQueryUtilitiesImpl
implements BooleanQueryUtilities {
    @Reference
    private FieldQueryFactory _fieldQueryFactory;
    @Reference
    private Queries _queries;

    public BooleanQuery addExactTerm(BooleanQuery booleanQuery, String field, Boolean value) {
        return this.addExactTerm(booleanQuery, field, (Object)value);
    }

    public BooleanQuery addExactTerm(BooleanQuery booleanQuery, String field, Double value) {
        return this.addExactTerm(booleanQuery, field, (Object)value);
    }

    public BooleanQuery addExactTerm(BooleanQuery booleanQuery, String field, Integer value) {
        return this.addExactTerm(booleanQuery, field, (Object)value);
    }

    public BooleanQuery addExactTerm(BooleanQuery booleanQuery, String field, Long value) {
        return this.addExactTerm(booleanQuery, field, (Object)value);
    }

    public BooleanQuery addExactTerm(BooleanQuery booleanQuery, String field, Short value) {
        return this.addExactTerm(booleanQuery, field, (Object)value);
    }

    public BooleanQuery addExactTerm(BooleanQuery booleanQuery, String field, String value) {
        return this.addExactTerm(booleanQuery, field, (Object)value);
    }

    public BooleanQuery addRangeTerm(BooleanQuery booleanQuery, String field, Integer startValue, Integer endValue) {
        return this.addRangeTerm(booleanQuery, field, (Object)startValue, (Object)endValue);
    }

    public BooleanQuery addRangeTerm(BooleanQuery booleanQuery, String field, Long startValue, Long endValue) {
        return this.addRangeTerm(booleanQuery, field, (Object)startValue, (Object)endValue);
    }

    public BooleanQuery addRangeTerm(BooleanQuery booleanQuery, String field, Short startValue, Short endValue) {
        return this.addRangeTerm(booleanQuery, field, (Object)startValue, (Object)endValue);
    }

    public BooleanQuery addRangeTerm(BooleanQuery booleanQuery, String field, String startValue, String endValue) {
        return this.addRangeTerm(booleanQuery, field, (Object)startValue, (Object)endValue);
    }

    public BooleanQuery addRequiredTerm(BooleanQuery booleanQuery, String field, Boolean value) {
        return this.addRequiredTerm(booleanQuery, field, (Object)value);
    }

    public BooleanQuery addRequiredTerm(BooleanQuery booleanQuery, String field, Double value) {
        return this.addRequiredTerm(booleanQuery, field, (Object)value);
    }

    public BooleanQuery addRequiredTerm(BooleanQuery booleanQuery, String field, Integer value) {
        return this.addRequiredTerm(booleanQuery, field, (Object)value);
    }

    public BooleanQuery addRequiredTerm(BooleanQuery booleanQuery, String field, Long value) {
        return this.addRequiredTerm(booleanQuery, field, (Object)value);
    }

    public BooleanQuery addRequiredTerm(BooleanQuery booleanQuery, String field, Short value) {
        return this.addRequiredTerm(booleanQuery, field, (Object)value);
    }

    public BooleanQuery addRequiredTerm(BooleanQuery booleanQuery, String field, String value) {
        return this.addRequiredTerm(booleanQuery, field, (Object)value);
    }

    public BooleanQuery addRequiredTerm(BooleanQuery booleanQuery, String field, String value, boolean like) {
        return this.addRequiredTerm(booleanQuery, field, value, like, false);
    }

    public BooleanQuery addRequiredTerm(BooleanQuery booleanQuery, String field, String value, boolean like, boolean parseKeywords) {
        Query query = this._fieldQueryFactory.createQuery(field, value, like, parseKeywords);
        return booleanQuery.addMustQueryClauses(new Query[]{query});
    }

    public BooleanQuery addTerm(BooleanQuery booleanQuery, String field, String value) {
        return this.addTerm(booleanQuery, field, value, false);
    }

    public BooleanQuery addTerm(BooleanQuery booleanQuery, String field, String value, boolean like) {
        return this.addTerm(booleanQuery, field, value, like, false);
    }

    public BooleanQuery addTerm(BooleanQuery booleanQuery, String field, String value, boolean like, boolean parseKeywords) {
        Query query = this._fieldQueryFactory.createQuery(field, value, like, false);
        return booleanQuery.addShouldQueryClauses(new Query[]{query});
    }

    public BooleanQuery addTerms(BooleanQuery booleanQuery, String[] fields, String value) {
        if (Validator.isNull((String)value) || ArrayUtil.isEmpty((Object[])fields)) {
            return booleanQuery;
        }
        for (String field : fields) {
            Query query = this._fieldQueryFactory.createQuery(field, value, false, false);
            booleanQuery.addShouldQueryClauses(new Query[]{query});
        }
        return booleanQuery;
    }

    public BooleanQuery addTerms(BooleanQuery booleanQuery, String[] fields, String value, boolean like) {
        if (Validator.isNull((String)value) || ArrayUtil.isEmpty((Object[])fields)) {
            return booleanQuery;
        }
        for (String field : fields) {
            Query query = this._fieldQueryFactory.createQuery(field, value, like, false);
            booleanQuery.addShouldQueryClauses(new Query[]{query});
        }
        return booleanQuery;
    }

    protected BooleanQuery addExactTerm(BooleanQuery booleanQuery, String field, Object value) {
        TermQuery termQuery = this._queries.term(field, value);
        return booleanQuery.addShouldQueryClauses(new Query[]{termQuery});
    }

    protected BooleanQuery addRangeTerm(BooleanQuery booleanQuery, String field, Object startValue, Object endValue) {
        RangeTermQuery rangeTermQuery = this._queries.rangeTerm(field, true, true, startValue, endValue);
        return booleanQuery.addShouldQueryClauses(new Query[]{rangeTermQuery});
    }

    protected BooleanQuery addRequiredTerm(BooleanQuery booleanQuery, String field, Object value) {
        TermQuery termQuery = this._queries.term(field, value);
        return booleanQuery.addMustQueryClauses(new Query[]{termQuery});
    }
}

