/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.query.field;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.analysis.KeywordTokenizer;
import com.liferay.portal.search.query.BooleanQuery;
import com.liferay.portal.search.query.Queries;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.query.field.FieldQueryBuilder;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SubstringFieldQueryBuilder.class})
public class SubstringFieldQueryBuilder
implements FieldQueryBuilder {
    @Reference
    protected KeywordTokenizer keywordTokenizer;
    @Reference
    protected Queries queries;

    public Query build(String field, String keywords) {
        BooleanQuery booleanQuery = this.queries.booleanQuery();
        List tokens = this.keywordTokenizer.tokenize(keywords);
        for (String token : tokens) {
            booleanQuery.addShouldQueryClauses(new Query[]{this.createQuery(field, token)});
        }
        return booleanQuery;
    }

    protected Query createQuery(String field, String value) {
        if (StringUtil.startsWith((String)value, (char)'\"')) {
            value = StringUtil.unquote((String)value);
        }
        value = (value = StringUtil.replace((String)value, (char)'%', (String)"")).isEmpty() ? "*" : StringUtil.quote((String)StringUtil.toLowerCase((String)value), (String)"*");
        return this.queries.wildcard(field, value);
    }
}

