/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.query.field;

import com.liferay.portal.search.query.MatchQuery;
import com.liferay.portal.search.query.Queries;
import com.liferay.portal.search.query.Query;

public class PhraseQueryBuilder {
    private Float _boost;
    private Integer _maxExpansions;
    private boolean _prefix;
    private final Queries _queries;
    private Integer _slop;
    private boolean _trailingStarAware;

    public PhraseQueryBuilder(Queries queries) {
        this._queries = queries;
    }

    public Query build(String field, String value) {
        MatchQuery.Type type = MatchQuery.Type.PHRASE;
        if (this._prefix) {
            type = MatchQuery.Type.PHRASE_PREFIX;
        }
        if (this._trailingStarAware && value.endsWith("*")) {
            value = value.substring(0, value.length() - 1);
            type = MatchQuery.Type.PHRASE_PREFIX;
        }
        MatchQuery matchQuery = this._queries.match(field, (Object)value);
        matchQuery.setType(type);
        if (this._boost != null) {
            matchQuery.setBoost(this._boost);
        }
        if (this._prefix && this._maxExpansions != null) {
            matchQuery.setMaxExpansions(this._maxExpansions);
        }
        if (this._slop != null) {
            matchQuery.setSlop(this._slop);
        }
        return matchQuery;
    }

    public void setBoost(float boost) {
        this._boost = Float.valueOf(boost);
    }

    public void setMaxExpansions(int maxExpansions) {
        this._maxExpansions = maxExpansions;
    }

    public void setPrefix(boolean prefix) {
        this._prefix = prefix;
    }

    public void setSlop(int slop) {
        this._slop = slop;
    }

    public void setTrailingStarAware(boolean trailingStarAware) {
        this._trailingStarAware = trailingStarAware;
    }
}

