/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.query.field;

import com.liferay.portal.search.internal.query.field.DescriptionFieldQueryBuilder;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.query.field.FieldQueryBuilder;
import com.liferay.portal.search.query.field.FieldQueryBuilderFactory;
import com.liferay.portal.search.query.field.FieldQueryFactory;
import java.util.HashSet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={FieldQueryFactory.class})
public class FieldQueryFactoryImpl
implements FieldQueryFactory {
    @Reference
    protected DescriptionFieldQueryBuilder descriptionFieldQueryBuilder;
    private final HashSet<FieldQueryBuilderFactory> _fieldQueryBuilderFactories = new HashSet();

    public Query createQuery(String fieldName, String keywords, boolean like, boolean splitKeywords) {
        FieldQueryBuilder fieldQueryBuilder = this.getQueryBuilder(fieldName);
        return fieldQueryBuilder.build(fieldName, keywords);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addFieldQueryBuilderFactory(FieldQueryBuilderFactory fieldQueryBuilderFactory) {
        this._fieldQueryBuilderFactories.add(fieldQueryBuilderFactory);
    }

    protected FieldQueryBuilder getQueryBuilder(String fieldName) {
        for (FieldQueryBuilderFactory fieldQueryBuilderFactory : this._fieldQueryBuilderFactories) {
            FieldQueryBuilder fieldQueryBuilder = fieldQueryBuilderFactory.getQueryBuilder(fieldName);
            if (fieldQueryBuilder == null) continue;
            return fieldQueryBuilder;
        }
        return this.descriptionFieldQueryBuilder;
    }

    protected void removeFieldQueryBuilderFactory(FieldQueryBuilderFactory fieldQueryBuilderFactory) {
        this._fieldQueryBuilderFactories.remove(fieldQueryBuilderFactory);
    }
}

