/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.query;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.ParseException;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.search.generic.NestedQuery;
import com.liferay.portal.kernel.search.generic.TermQueryImpl;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.query.NestedFieldQueryHelper;
import java.util.function.Function;
import org.osgi.service.component.annotations.Component;

@Component(service={NestedFieldQueryHelper.class})
public class NestedFieldQueryHelperImpl
implements NestedFieldQueryHelper {
    public Query getQuery(String field, Function<String, Query> queryFunction) {
        if (field.startsWith("nestedFieldArray.") && field.contains("#")) {
            BooleanQueryImpl booleanQuery = new BooleanQueryImpl();
            String[] parts = StringUtil.split((String)field, (String)"#");
            String fieldName = parts[1];
            String valueFieldName = parts[0];
            try {
                booleanQuery.add(queryFunction.apply(valueFieldName), BooleanClauseOccur.MUST);
                booleanQuery.add((Query)new TermQueryImpl("nestedFieldArray.fieldName", fieldName), BooleanClauseOccur.MUST);
            }
            catch (ParseException parseException) {
                throw new SystemException((Throwable)parseException);
            }
            return new NestedQuery("nestedFieldArray", (Query)booleanQuery);
        }
        return queryFunction.apply(field);
    }
}

