/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.query;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.search.internal.query.BaseQueryImpl;
import com.liferay.portal.search.query.MatchQuery;
import com.liferay.portal.search.query.MultiMatchQuery;
import com.liferay.portal.search.query.Operator;
import com.liferay.portal.search.query.QueryVisitor;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MultiMatchQueryImpl
extends BaseQueryImpl
implements MultiMatchQuery {
    private static final long serialVersionUID = 1L;
    private String _analyzer;
    private Float _cutOffFrequency;
    private Map<String, Float> _fieldsBoosts = new HashMap<String, Float>();
    private String _fuzziness;
    private MatchQuery.RewriteMethod _fuzzyRewriteMethod;
    private Boolean _lenient;
    private Integer _maxExpansions;
    private String _minShouldMatch;
    private Operator _operator;
    private Integer _prefixLength;
    private Integer _slop;
    private Float _tieBreaker;
    private MultiMatchQuery.Type _type;
    private final Object _value;
    private MatchQuery.ZeroTermsQuery _zeroTermsQuery;

    public MultiMatchQueryImpl(Object value, Map<String, Float> fieldsBoosts) {
        this._value = value;
        this._fieldsBoosts = fieldsBoosts;
    }

    public MultiMatchQueryImpl(Object value, Set<String> fields) {
        this._value = value;
        for (String field : fields) {
            this._fieldsBoosts.put(field, null);
        }
    }

    public MultiMatchQueryImpl(Object value, String ... fields) {
        this._value = value;
        for (String field : fields) {
            this._fieldsBoosts.put(field, null);
        }
    }

    public <T> T accept(QueryVisitor<T> queryVisitor) {
        return (T)queryVisitor.visit((MultiMatchQuery)this);
    }

    public String getAnalyzer() {
        return this._analyzer;
    }

    public Float getCutOffFrequency() {
        return this._cutOffFrequency;
    }

    @Deprecated
    public Set<String> getFields() {
        return this._fieldsBoosts.keySet();
    }

    public Map<String, Float> getFieldsBoosts() {
        return this._fieldsBoosts;
    }

    public String getFuzziness() {
        return this._fuzziness;
    }

    public MatchQuery.RewriteMethod getFuzzyRewriteMethod() {
        return this._fuzzyRewriteMethod;
    }

    public Integer getMaxExpansions() {
        return this._maxExpansions;
    }

    public String getMinShouldMatch() {
        return this._minShouldMatch;
    }

    public Operator getOperator() {
        return this._operator;
    }

    public Integer getPrefixLength() {
        return this._prefixLength;
    }

    public Integer getSlop() {
        return this._slop;
    }

    public Float getTieBreaker() {
        return this._tieBreaker;
    }

    public MultiMatchQuery.Type getType() {
        return this._type;
    }

    public Object getValue() {
        return this._value;
    }

    public MatchQuery.ZeroTermsQuery getZeroTermsQuery() {
        return this._zeroTermsQuery;
    }

    public boolean isFieldBoostsEmpty() {
        return this._fieldsBoosts.isEmpty();
    }

    @Deprecated
    public boolean isFieldsEmpty() {
        return this._fieldsBoosts.isEmpty();
    }

    public Boolean isLenient() {
        return this._lenient;
    }

    public void setAnalyzer(String analyzer) {
        this._analyzer = analyzer;
    }

    public void setCutOffFrequency(Float cutOffFrequency) {
        this._cutOffFrequency = cutOffFrequency;
    }

    public void setFuzziness(String fuzziness) {
        this._fuzziness = fuzziness;
    }

    public void setFuzzyRewriteMethod(MatchQuery.RewriteMethod fuzzyRewriteMethod) {
        this._fuzzyRewriteMethod = fuzzyRewriteMethod;
    }

    public void setLenient(Boolean lenient) {
        this._lenient = lenient;
    }

    public void setMaxExpansions(Integer maxExpansions) {
        this._maxExpansions = maxExpansions;
    }

    public void setMinShouldMatch(String minShouldMatch) {
        this._minShouldMatch = minShouldMatch;
    }

    public void setOperator(Operator operator) {
        this._operator = operator;
    }

    public void setPrefixLength(Integer prefixLength) {
        this._prefixLength = prefixLength;
    }

    public void setSlop(Integer slop) {
        this._slop = slop;
    }

    public void setTieBreaker(Float tieBreaker) {
        this._tieBreaker = tieBreaker;
    }

    public void setType(MultiMatchQuery.Type type) {
        this._type = type;
    }

    public void setZeroTermsQuery(MatchQuery.ZeroTermsQuery zeroTermsQuery) {
        this._zeroTermsQuery = zeroTermsQuery;
    }

    public String toString() {
        StringBundler sb = new StringBundler(29);
        sb.append("{analyzer=");
        sb.append(this._analyzer);
        sb.append(", className=");
        Class<?> clazz = this.getClass();
        sb.append(clazz.getSimpleName());
        sb.append(", cutOffFrequency=");
        sb.append((Object)this._cutOffFrequency);
        sb.append(", _fieldsBoosts=");
        sb.append(this._fieldsBoosts);
        sb.append(", fuzziness=");
        sb.append(this._fuzziness);
        sb.append(", lenient=");
        sb.append((Object)this._lenient);
        sb.append(", maxExpansions=");
        sb.append((Object)this._maxExpansions);
        sb.append(", minShouldMatch=");
        sb.append(this._minShouldMatch);
        sb.append(", operator=");
        sb.append((Object)this._operator);
        sb.append(", prefixLength=");
        sb.append((Object)this._prefixLength);
        sb.append(", slop=");
        sb.append((Object)this._slop);
        sb.append(", tieBreaker=");
        sb.append((Object)this._tieBreaker);
        sb.append(", type=");
        sb.append((Object)this._type);
        sb.append(", value=");
        sb.append(this._value);
        sb.append("}");
        return sb.toString();
    }
}

