/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.localization;

import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.search.localization.SearchLocalizationHelper;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={SearchLocalizationHelper.class})
public class SearchLocalizationHelperImpl
implements SearchLocalizationHelper {
    @Reference
    private Language _language;

    public void addLocalizedField(Document document, String field, Locale defaultLocale, Map<Locale, String> map) {
        for (Map.Entry<Locale, String> entry : map.entrySet()) {
            Locale locale = entry.getKey();
            if (locale.equals(defaultLocale)) {
                document.addText(field, entry.getValue());
            }
            document.addText(Field.getLocalizedName((Locale)locale, (String)field), entry.getValue());
        }
    }

    public Locale[] getLocales(SearchContext searchContext) {
        long[] groupIds = searchContext.getGroupIds();
        if (ArrayUtil.isEmpty((long[])groupIds)) {
            Set locales = this._language.getCompanyAvailableLocales(searchContext.getCompanyId());
            return locales.toArray(new Locale[0]);
        }
        if (groupIds.length == 1) {
            Set locales = this._language.getAvailableLocales(groupIds[0]);
            return locales.toArray(new Locale[0]);
        }
        HashSet locales = new HashSet();
        for (long groupId : groupIds) {
            locales.addAll(this._language.getAvailableLocales(groupId));
        }
        return locales.toArray(new Locale[0]);
    }

    public String[] getLocalizedFieldNames(String[] prefixes, SearchContext searchContext) {
        return this.getLocalizedFieldNames(prefixes, this.getLocales(searchContext));
    }

    protected String[] getLocalizedFieldNames(String[] prefixes, Locale[] locales) {
        HashSet<String> fieldNames = new HashSet<String>();
        for (String prefix : prefixes) {
            for (Locale locale : locales) {
                fieldNames.add(Field.getLocalizedName((Locale)locale, (String)prefix));
            }
        }
        return fieldNames.toArray(new String[0]);
    }
}

