/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.legacy.searcher;

import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.aggregation.Aggregation;
import com.liferay.portal.search.aggregation.pipeline.PipelineAggregation;
import com.liferay.portal.search.filter.ComplexQueryPart;
import com.liferay.portal.search.groupby.GroupByRequest;
import com.liferay.portal.search.highlight.Highlight;
import com.liferay.portal.search.internal.legacy.searcher.FacetContextImpl;
import com.liferay.portal.search.internal.searcher.SearchRequestImpl;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.rescore.Rescore;
import com.liferay.portal.search.searcher.FacetContext;
import com.liferay.portal.search.searcher.SearchRequest;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import com.liferay.portal.search.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.sort.Sort;
import com.liferay.portal.search.stats.StatsRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

public class SearchRequestBuilderImpl
implements SearchRequestBuilder {
    private static final String _SEARCH_CONTEXT_KEY_SEARCH_REQUEST = "search.request";
    private final FacetContext _facetContext;
    private final Map<String, SearchRequestBuilder> _federatedSearchRequestBuildersMap = new LinkedHashMap<String, SearchRequestBuilder>();
    private final SearchContext _searchContext;
    private final SearchRequestBuilderFactory _searchRequestBuilderFactory;

    public SearchRequestBuilderImpl(SearchRequestBuilderFactory searchRequestBuilderFactory) {
        this(searchRequestBuilderFactory, new SearchContext());
    }

    public SearchRequestBuilderImpl(SearchRequestBuilderFactory searchRequestBuilderFactory, SearchContext searchContext) {
        this._searchRequestBuilderFactory = searchRequestBuilderFactory;
        this._searchContext = searchContext;
        this._facetContext = new FacetContextImpl(searchContext);
    }

    public SearchRequestBuilderImpl(SearchRequestBuilderFactory searchRequestBuilderFactory, SearchRequest searchRequest) {
        this(searchRequestBuilderFactory, new SearchRequestImpl((SearchRequestImpl)searchRequest).getSearchContext());
    }

    public SearchRequestBuilder addAggregation(Aggregation aggregation) {
        this._withSearchRequestImpl(searchRequestImpl -> searchRequestImpl.addAggregation(aggregation));
        return this;
    }

    public SearchRequestBuilder addComplexQueryPart(ComplexQueryPart complexQueryPart) {
        if (complexQueryPart != null) {
            this._withSearchRequestImpl(searchRequestImpl -> searchRequestImpl.addComplexQueryPart(complexQueryPart));
        }
        return this;
    }

    public SearchRequestBuilder addFederatedSearchRequest(SearchRequest searchRequest) {
        this._addFederatedSearchRequests(Arrays.asList(searchRequest));
        return this;
    }

    public SearchRequestBuilder addIndex(String index) {
        this._withSearchRequestImpl(searchRequestImpl -> searchRequestImpl.addIndex(index));
        return this;
    }

    public SearchRequestBuilder addPipelineAggregation(PipelineAggregation pipelineAggregation) {
        this._withSearchRequestImpl(searchRequestImpl -> searchRequestImpl.addPipelineAggregation(pipelineAggregation));
        return this;
    }

    public SearchRequestBuilder addPostFilterQueryPart(ComplexQueryPart complexQueryPart) {
        if (complexQueryPart != null) {
            this._withSearchRequestImpl(searchRequestImpl -> searchRequestImpl.addPostFilterQueryPart(complexQueryPart));
        }
        return this;
    }

    public SearchRequestBuilder addRescore(Rescore rescore) {
        this._withSearchRequestImpl(searchRequestImpl -> searchRequestImpl.addRescore(rescore));
        return this;
    }

    public SearchRequestBuilder addSelectedFieldNames(String ... selectedFieldNames) {
        this._withSearchRequestImpl(searchRequestImpl -> searchRequestImpl.addSelectedFieldNames(selectedFieldNames));
        return this;
    }

    public SearchRequestBuilder addSort(Sort sort) {
        this._withSearchRequestImpl(searchRequestImpl -> searchRequestImpl.addSort(sort));
        return this;
    }

    public SearchRequestBuilder basicFacetSelection(boolean basicFacetSelection) {
        this._withSearchRequestImpl(searchRequestImpl -> searchRequestImpl.setBasicFacetSelection(basicFacetSelection));
        return this;
    }

    public SearchRequest build() {
        this.basicFacetSelection(SearchRequestImpl.isBasicFacetSelection(this._searchContext));
        this._addFederatedSearchRequests(this._buildFederatedSearchRequests());
        return (SearchRequest)this._withSearchRequestGet(Function.identity());
    }

    public SearchRequestBuilder companyId(Long companyId) {
        this._withSearchRequestImpl(searchRequestImpl -> searchRequestImpl.setCompanyId(companyId));
        return this;
    }

    public SearchRequestBuilder connectionId(String connectionId) {
        this._withSearchRequestImpl(searchRequestImpl -> searchRequestImpl.setConnectionId(connectionId));
        return this;
    }

    public SearchRequestBuilder emptySearchEnabled(boolean allowEmptySearches) {
        this._withSearchRequestImpl(searchRequestImpl -> searchRequestImpl.setEmptySearchEnabled(allowEmptySearches));
        return this;
    }

    public SearchRequestBuilder entryClassNames(String ... entryClassNames) {
        this._withSearchRequestImpl(searchRequestImpl -> searchRequestImpl.addEntryClassNames(entryClassNames));
        return this;
    }

    public SearchRequestBuilder excludeContributors(String ... ids) {
        this._withSearchRequestImpl(searchRequestImpl -> searchRequestImpl.addExcludeContributors(ids));
        return this;
    }

    public SearchRequestBuilder explain(boolean explain) {
        this._withSearchRequestImpl(searchRequestImpl -> searchRequestImpl.setExplain(explain));
        return this;
    }

    public SearchRequestBuilder federatedSearchKey(String federatedSearchKey) {
        this._withSearchRequestImpl(searchRequestImpl -> searchRequestImpl.setFederatedSearchKey(federatedSearchKey));
        return this;
    }

    public SearchRequestBuilder fetchSource(boolean fetchSource) {
        this._withSearchRequestImpl(searchRequestImpl -> searchRequestImpl.setFetchSource(fetchSource));
        return this;
    }

    public SearchRequestBuilder fetchSourceExcludes(String[] fetchSourceExcludes) {
        this._withSearchRequestImpl(searchRequestImpl -> searchRequestImpl.setFetchSourceExcludes(fetchSourceExcludes));
        return this;
    }

    public SearchRequestBuilder fetchSourceIncludes(String[] fetchSourceIncludes) {
        this._withSearchRequestImpl(searchRequestImpl -> searchRequestImpl.setFetchSourceIncludes(fetchSourceIncludes));
        return this;
    }

    public SearchRequestBuilder fields(String ... fields) {
        this._withSearchRequestImpl(searchRequestImpl -> searchRequestImpl.setSelectedFieldNames(fields));
        return this;
    }

    public SearchRequestBuilder from(Integer from) {
        this._withSearchRequestImpl(searchRequestImpl -> searchRequestImpl.setFrom(from));
        return this;
    }

    public SearchRequestBuilder getFederatedSearchRequestBuilder(String federatedSearchKey) {
        if (Validator.isBlank((String)federatedSearchKey)) {
            return this;
        }
        return this._federatedSearchRequestBuildersMap.computeIfAbsent(federatedSearchKey, this::_newFederatedSearchRequestBuilder);
    }

    public SearchRequestBuilder groupByRequests(GroupByRequest ... groupByRequests) {
        this._withSearchRequestImpl(searchRequestImpl -> searchRequestImpl.setGroupByRequests(groupByRequests));
        return this;
    }

    public SearchRequestBuilder groupIds(long ... groupIds) {
        this._withSearchRequestImpl(searchRequestImpl -> searchRequestImpl.setGroupIds(groupIds));
        return this;
    }

    public SearchRequestBuilder highlight(Highlight highlight) {
        this._withSearchRequestImpl(searchRequestImpl -> searchRequestImpl.setHighlight(highlight));
        return this;
    }

    public SearchRequestBuilder highlightEnabled(boolean highlightEnabled) {
        this._withSearchRequestImpl(searchRequestImpl -> searchRequestImpl.setHighlightEnabled(highlightEnabled));
        return this;
    }

    public SearchRequestBuilder highlightFields(String ... highlightFields) {
        this._withSearchRequestImpl(searchRequestImpl -> searchRequestImpl.setHighlightFields(highlightFields));
        return this;
    }

    public SearchRequestBuilder includeContributors(String ... ids) {
        this._withSearchRequestImpl(searchRequestImpl -> searchRequestImpl.addIncludeContributors(ids));
        return this;
    }

    public SearchRequestBuilder includeResponseString(boolean includeResponseString) {
        this._withSearchRequestImpl(searchRequestImpl -> searchRequestImpl.setIncludeResponseString(includeResponseString));
        return this;
    }

    public SearchRequestBuilder indexes(String ... indexes) {
        this._withSearchRequestImpl(searchRequestImpl -> searchRequestImpl.setIndexes(indexes));
        return this;
    }

    public SearchRequestBuilder locale(Locale locale) {
        this._withSearchRequestImpl(searchRequestImpl -> searchRequestImpl.setLocale(locale));
        return this;
    }

    public SearchRequestBuilder modelIndexerClasses(Class<?> ... classes) {
        String[] classNames = (String[])Stream.of(classes).map(clazz -> clazz.getCanonicalName()).toArray(String[]::new);
        this._withSearchRequestImpl(searchRequestImpl -> searchRequestImpl.setModelIndexerClassNames(classNames));
        return this;
    }

    public SearchRequestBuilder modelIndexerClassNames(String ... classNames) {
        this._withSearchRequestImpl(searchRequestImpl -> searchRequestImpl.setModelIndexerClassNames(classNames));
        return this;
    }

    public SearchRequestBuilder ownerUserId(Long userId) {
        this._withSearchRequestImpl(searchRequestImpl -> searchRequestImpl.setOwnerUserId(userId));
        return this;
    }

    public void paginationStartParameterName(String paginationStartParameterName) {
        this._withSearchRequestImpl(searchRequestImpl -> searchRequestImpl.setPaginationStartParameterName(paginationStartParameterName));
    }

    public SearchRequestBuilder postFilterQuery(Query query) {
        this._withSearchRequestImpl(searchRequestImpl -> searchRequestImpl.setPostFilterQuery(query));
        return this;
    }

    public SearchRequestBuilder query(Query query) {
        this._withSearchRequestImpl(searchRequestImpl -> searchRequestImpl.setQuery(query));
        return this;
    }

    public SearchRequestBuilder queryString(String queryString) {
        this._withSearchRequestImpl(searchRequestImpl -> searchRequestImpl.setQueryString(queryString));
        return this;
    }

    @Deprecated
    public SearchRequestBuilder rescoreQuery(Query query) {
        return this;
    }

    public SearchRequestBuilder rescores(List<Rescore> rescores) {
        this._withSearchRequestImpl(searchRequestImpl -> searchRequestImpl.setRescores(rescores));
        return this;
    }

    public SearchRequestBuilder size(Integer size) {
        this._withSearchRequestImpl(searchRequestImpl -> searchRequestImpl.setSize(size));
        return this;
    }

    public SearchRequestBuilder sorts(Sort ... sorts) {
        this._withSearchRequestImpl(searchRequestImpl -> searchRequestImpl.setSorts(sorts));
        return this;
    }

    public SearchRequestBuilder statsRequests(StatsRequest ... statsRequests) {
        this._withSearchRequestImpl(searchRequestImpl -> searchRequestImpl.setStatsRequests(statsRequests));
        return this;
    }

    public SearchRequestBuilder withFacetContext(Consumer<FacetContext> facetContextConsumer) {
        facetContextConsumer.accept(this._facetContext);
        return this;
    }

    public <T> T withFacetContextGet(Function<FacetContext, T> facetContextFunction) {
        return facetContextFunction.apply(this._facetContext);
    }

    public SearchRequestBuilder withSearchContext(Consumer<SearchContext> searchContextConsumer) {
        searchContextConsumer.accept(this._searchContext);
        return this;
    }

    public <T> T withSearchContextGet(Function<SearchContext, T> searchContextFunction) {
        return searchContextFunction.apply(this._searchContext);
    }

    public SearchRequestBuilder withSearchRequestBuilder(Consumer<SearchRequestBuilder> ... searchRequestBuilderConsumers) {
        Stream.of(searchRequestBuilderConsumers).forEach(searchRequestBuilderConsumer -> searchRequestBuilderConsumer.accept(this));
        return this;
    }

    protected static <T extends Serializable> T setAttribute(SearchContext searchContext, String key, T value) {
        searchContext.setAttribute(key, value);
        return value;
    }

    private void _addFederatedSearchRequests(List<SearchRequest> searchRequests) {
        this._withSearchRequestImpl(searchRequestImpl -> searchRequests.forEach(searchRequestImpl::addFederatedSearchRequest));
    }

    private List<SearchRequest> _buildFederatedSearchRequests() {
        Collection<SearchRequestBuilder> searchRequestBuilders = this._federatedSearchRequestBuildersMap.values();
        ArrayList<SearchRequest> searchRequests = new ArrayList<SearchRequest>(searchRequestBuilders.size());
        for (SearchRequestBuilder searchRequestBuilder : searchRequestBuilders) {
            searchRequests.add(searchRequestBuilder.build());
        }
        return searchRequests;
    }

    private SearchRequestImpl _getSearchRequestImpl(SearchContext searchContext) {
        return Optional.ofNullable((SearchRequestImpl)searchContext.getAttribute(_SEARCH_CONTEXT_KEY_SEARCH_REQUEST)).orElseGet(() -> SearchRequestBuilderImpl.setAttribute(searchContext, _SEARCH_CONTEXT_KEY_SEARCH_REQUEST, new SearchRequestImpl(searchContext)));
    }

    private SearchRequestBuilder _newFederatedSearchRequestBuilder(String federatedSearchKey) {
        return this._searchRequestBuilderFactory.builder().federatedSearchKey(federatedSearchKey).withSearchContext(searchContext -> searchContext.setCompanyId(this._searchContext.getCompanyId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T _withSearchRequestGet(Function<SearchRequest, T> searchRequestFunction) {
        SearchContext searchContext = this._searchContext;
        synchronized (searchContext) {
            return searchRequestFunction.apply(this._getSearchRequestImpl(this._searchContext));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _withSearchRequestImpl(Consumer<SearchRequestImpl> searchRequestImplConsumer) {
        SearchContext searchContext = this._searchContext;
        synchronized (searchContext) {
            searchRequestImplConsumer.accept(this._getSearchRequestImpl(this._searchContext));
        }
    }
}

