/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.indexer.helper;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerPostProcessor;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.search.internal.indexer.IndexerProvidedClausesUtil;
import com.liferay.portal.search.internal.indexer.helper.PostProcessSearchQueryContributorHelper;
import java.util.Collection;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={PostProcessSearchQueryContributorHelper.class})
public class PostProcessSearchQueryContributorHelperImpl
implements PostProcessSearchQueryContributorHelper {
    private static final Log _log = LogFactoryUtil.getLog(PostProcessSearchQueryContributorHelperImpl.class);

    @Override
    public void contribute(BooleanQuery booleanQuery, BooleanFilter booleanFilter, Collection<Indexer<?>> indexers, SearchContext searchContext) {
        if (IndexerProvidedClausesUtil.shouldSuppress(searchContext)) {
            return;
        }
        this._addIndexerProvidedClauses(booleanQuery, booleanFilter, indexers, searchContext);
    }

    protected IndexerPostProcessor[] getIndexerPostProcessors(Indexer<?> indexer) {
        try {
            return indexer.getIndexerPostProcessors();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)unsupportedOperationException);
            }
            return new IndexerPostProcessor[0];
        }
    }

    private void _addIndexerProvidedClauses(BooleanQuery booleanQuery, BooleanFilter booleanFilter, Collection<Indexer<?>> indexers, SearchContext searchContext) {
        for (Indexer<?> indexer : indexers) {
            this._addIndexerProvidedSearchTerms(booleanQuery, indexer, booleanFilter, searchContext);
        }
    }

    private void _addIndexerProvidedSearchTerms(BooleanQuery booleanQuery, Indexer<?> indexer, BooleanFilter booleanFilter, SearchContext searchContext) {
        boolean luceneSyntax = GetterUtil.getBoolean((Object)searchContext.getAttribute("search.lucene.syntax"));
        if (!luceneSyntax) {
            this._postProcessSearchQuery(booleanQuery, booleanFilter, searchContext, indexer);
        }
        for (IndexerPostProcessor indexerPostProcessor : this.getIndexerPostProcessors(indexer)) {
            this._postProcessSearchQuery(booleanQuery, booleanFilter, searchContext, indexerPostProcessor);
        }
    }

    private void _postProcessSearchQuery(BooleanQuery booleanQuery, BooleanFilter booleanFilter, SearchContext searchContext, Indexer<?> indexer) {
        try {
            indexer.postProcessSearchQuery(booleanQuery, booleanFilter, searchContext);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private void _postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter booleanFilter, SearchContext searchContext, IndexerPostProcessor indexerPostProcessor) {
        try {
            indexerPostProcessor.postProcessSearchQuery(searchQuery, booleanFilter, searchContext);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

