/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.indexer.helper;

import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.ParseException;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.generic.StringQuery;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.internal.indexer.IndexerProvidedClausesUtil;
import com.liferay.portal.search.internal.indexer.KeywordQueryContributorsRegistry;
import com.liferay.portal.search.internal.indexer.helper.AddSearchKeywordsQueryContributorHelper;
import com.liferay.portal.search.internal.util.SearchStringUtil;
import com.liferay.portal.search.spi.model.query.contributor.KeywordQueryContributor;
import com.liferay.portal.search.spi.model.query.contributor.helper.KeywordQueryContributorHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={AddSearchKeywordsQueryContributorHelper.class})
public class AddSearchKeywordsQueryContributorHelperImpl
implements AddSearchKeywordsQueryContributorHelper {
    @Reference
    protected KeywordQueryContributorsRegistry keywordQueryContributorsRegistry;

    @Override
    public void contribute(BooleanQuery booleanQuery, SearchContext searchContext) {
        if (IndexerProvidedClausesUtil.shouldSuppress(searchContext)) {
            return;
        }
        this._addKeywordQueryContributorClauses(booleanQuery, searchContext);
    }

    protected Collection<String> getStrings(String string, SearchContext searchContext) {
        return Arrays.asList(SearchStringUtil.splitAndUnquote(Optional.ofNullable((String)((Object)searchContext.getAttribute(string)))));
    }

    private void _addKeywordQueryContributorClauses(BooleanQuery booleanQuery, final SearchContext searchContext) {
        boolean luceneSyntax = GetterUtil.getBoolean((Object)searchContext.getAttribute("search.lucene.syntax"));
        String keywords = searchContext.getKeywords();
        if (luceneSyntax) {
            this._addStringQuery(booleanQuery, keywords);
            return;
        }
        Stream<KeywordQueryContributor> stream = this.keywordQueryContributorsRegistry.stream(this.getStrings("search.full.query.clause.contributors.excludes", searchContext), this.getStrings("search.full.query.clause.contributors.includes", searchContext));
        stream.forEach(keywordQueryContributor -> keywordQueryContributor.contribute(keywords, booleanQuery, new KeywordQueryContributorHelper(){

            public String getClassName() {
                return null;
            }

            public Stream<String> getSearchClassNamesStream() {
                throw new UnsupportedOperationException();
            }

            public SearchContext getSearchContext() {
                return searchContext;
            }
        }));
    }

    private void _addStringQuery(BooleanQuery booleanQuery, String keywords) {
        if (Validator.isBlank((String)keywords)) {
            return;
        }
        try {
            booleanQuery.add((Query)new StringQuery(keywords), BooleanClauseOccur.MUST);
        }
        catch (ParseException parseException) {
            throw new RuntimeException(parseException);
        }
    }
}

