/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.indexer;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.search.internal.indexer.ModelPreFilterContributorsRegistry;
import com.liferay.portal.search.spi.model.query.contributor.ModelPreFilterContributor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(immediate=true, service={ModelPreFilterContributorsRegistry.class})
public class ModelPreFilterContributorsRegistryImpl
implements ModelPreFilterContributorsRegistry {
    private ServiceTrackerMap<String, List<ModelPreFilterContributor>> _classNameServiceTrackerMap;
    private ServiceTrackerMap<String, List<ModelPreFilterContributor>> _mandatoryServiceTrackerMap;

    @Override
    public Stream<ModelPreFilterContributor> stream(String entryClassName, Collection<String> excludes, Collection<String> includes, boolean mandatoryOnly) {
        ArrayList<ModelPreFilterContributor> list = new ArrayList<ModelPreFilterContributor>();
        this._addAll(list, this._getAllClassesContributors());
        this._addAll(list, this._getClassContributors(entryClassName));
        if (mandatoryOnly) {
            this._retainAll(list, this._getMandatoryContributors());
        } else {
            List<String> mandatoryContributorClassNames = this._getMandatoryContributorNames(this._getMandatoryContributors());
            if (includes != null && !includes.isEmpty()) {
                list.removeIf(modelPreFilterContributor -> {
                    String className = this._getClassName(modelPreFilterContributor);
                    return !mandatoryContributorClassNames.contains(className) && !includes.contains(className);
                });
            }
            if (excludes != null && !excludes.isEmpty()) {
                list.removeIf(modelPreFilterContributor -> {
                    String className = this._getClassName(modelPreFilterContributor);
                    return !mandatoryContributorClassNames.contains(className) && excludes.contains(className);
                });
            }
        }
        return list.stream();
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._classNameServiceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)bundleContext, ModelPreFilterContributor.class, (String)"indexer.class.name");
        this._mandatoryServiceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)bundleContext, ModelPreFilterContributor.class, (String)"indexer.clauses.mandatory");
    }

    @Deactivate
    protected void deactivate() {
        this._classNameServiceTrackerMap.close();
        this._mandatoryServiceTrackerMap.close();
    }

    private void _addAll(List<ModelPreFilterContributor> list1, List<ModelPreFilterContributor> list2) {
        if (list2 == null) {
            return;
        }
        list1.addAll(list2);
    }

    private List<ModelPreFilterContributor> _getAllClassesContributors() {
        return (List)this._classNameServiceTrackerMap.getService((Object)"ALL");
    }

    private List<ModelPreFilterContributor> _getClassContributors(String entryClassName) {
        return (List)this._classNameServiceTrackerMap.getService((Object)entryClassName);
    }

    private String _getClassName(Object object) {
        Class<?> clazz = object.getClass();
        return clazz.getName();
    }

    private List<String> _getMandatoryContributorNames(List<ModelPreFilterContributor> mandatoryContributors) {
        Stream stream = mandatoryContributors.stream();
        return stream.map(modelPreFilterContributor -> this._getClassName(modelPreFilterContributor)).collect(Collectors.toList());
    }

    private List<ModelPreFilterContributor> _getMandatoryContributors() {
        return (List)this._mandatoryServiceTrackerMap.getService((Object)"true");
    }

    private void _retainAll(List<ModelPreFilterContributor> list1, List<ModelPreFilterContributor> list2) {
        if (list2 == null) {
            return;
        }
        list1.retainAll(list2);
    }
}

