/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.indexer;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.model.WorkflowedModel;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.search.batch.BatchIndexingActionable;
import com.liferay.portal.search.batch.BatchIndexingHelper;
import com.liferay.portal.search.index.IndexStatusManager;
import com.liferay.portal.search.index.UpdateDocumentIndexWriter;
import com.liferay.portal.search.indexer.BaseModelRetriever;
import com.liferay.portal.search.indexer.IndexerDocumentBuilder;
import com.liferay.portal.search.indexer.IndexerWriter;
import com.liferay.portal.search.internal.index.contributor.helper.ModelIndexerWriterDocumentHelperImpl;
import com.liferay.portal.search.permission.SearchPermissionIndexWriter;
import com.liferay.portal.search.spi.model.index.contributor.ModelIndexerWriterContributor;
import com.liferay.portal.search.spi.model.index.contributor.helper.IndexerWriterMode;
import com.liferay.portal.search.spi.model.index.contributor.helper.ModelIndexerWriterDocumentHelper;
import com.liferay.portal.search.spi.model.registrar.ModelSearchSettings;
import java.util.Collection;
import java.util.Optional;

public class IndexerWriterImpl<T extends BaseModel<?>>
implements IndexerWriter<T> {
    private static final Log _log = LogFactoryUtil.getLog(IndexerWriterImpl.class);
    private final BaseModelRetriever _baseModelRetriever;
    private final BatchIndexingHelper _batchIndexingHelper;
    private final IndexerDocumentBuilder _indexerDocumentBuilder;
    private Boolean _indexerEnabled;
    private final IndexStatusManager _indexStatusManager;
    private final IndexWriterHelper _indexWriterHelper;
    private final ModelIndexerWriterContributor<T> _modelIndexerWriterContributor;
    private final ModelSearchSettings _modelSearchSettings;
    private final Props _props;
    private final SearchPermissionIndexWriter _searchPermissionIndexWriter;
    private final UpdateDocumentIndexWriter _updateDocumentIndexWriter;

    public IndexerWriterImpl(ModelSearchSettings modelSearchSettings, BaseModelRetriever baseModelRetriever, BatchIndexingHelper batchIndexingHelper, ModelIndexerWriterContributor<T> modelIndexerWriterContributor, IndexerDocumentBuilder indexerDocumentBuilder, SearchPermissionIndexWriter searchPermissionIndexWriter, UpdateDocumentIndexWriter updateDocumentIndexWriter, IndexStatusManager indexStatusManager, IndexWriterHelper indexWriterHelper, Props props) {
        this._modelSearchSettings = modelSearchSettings;
        this._baseModelRetriever = baseModelRetriever;
        this._batchIndexingHelper = batchIndexingHelper;
        this._modelIndexerWriterContributor = modelIndexerWriterContributor;
        this._indexerDocumentBuilder = indexerDocumentBuilder;
        this._searchPermissionIndexWriter = searchPermissionIndexWriter;
        this._updateDocumentIndexWriter = updateDocumentIndexWriter;
        this._indexStatusManager = indexStatusManager;
        this._indexWriterHelper = indexWriterHelper;
        this._props = props;
    }

    public void delete(long companyId, String uid) {
        if (!this.isEnabled()) {
            return;
        }
        try {
            this._indexWriterHelper.deleteDocument(companyId, uid, this._modelSearchSettings.isCommitImmediately());
        }
        catch (SearchException searchException) {
            throw new RuntimeException(searchException);
        }
    }

    public void delete(T baseModel) {
        if (baseModel == null) {
            return;
        }
        long companyId = this._modelIndexerWriterContributor.getCompanyId(baseModel);
        String uid = this._indexerDocumentBuilder.getDocumentUID(baseModel);
        this.delete(companyId, uid);
    }

    public BatchIndexingActionable getBatchIndexingActionable() {
        BatchIndexingActionable batchIndexingActionable = this._modelIndexerWriterContributor.getBatchIndexingActionable();
        batchIndexingActionable.setInterval(this._batchIndexingHelper.getBulkSize(this._modelSearchSettings.getClassName()));
        return batchIndexingActionable;
    }

    public boolean isEnabled() {
        if (this._indexerEnabled == null) {
            String indexerEnabled = this._props.get("indexer.enabled", new Filter(this._modelSearchSettings.getClassName()));
            this._indexerEnabled = GetterUtil.getBoolean((String)indexerEnabled, (boolean)true);
            return this._indexerEnabled;
        }
        return !this._indexStatusManager.isIndexReadOnly() && !this._indexStatusManager.isIndexReadOnly(this._modelSearchSettings.getClassName()) && this._indexerEnabled != false;
    }

    public void reindex(Collection<T> baseModels) {
        if (!this.isEnabled() || baseModels == null || baseModels.isEmpty()) {
            return;
        }
        for (BaseModel baseModel : baseModels) {
            this.reindex(baseModel);
        }
    }

    public void reindex(long classPK) {
        if (!this.isEnabled() || classPK <= 0L) {
            return;
        }
        Optional baseModelOptional = this._baseModelRetriever.fetchBaseModel(this._modelSearchSettings.getClassName(), classPK);
        baseModelOptional.ifPresent(baseModel -> this.reindex(baseModel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reindex(String[] ids) {
        if (!this.isEnabled() || ArrayUtil.isEmpty((Object[])ids)) {
            return;
        }
        long companyThreadLocalCompanyId = CompanyThreadLocal.getCompanyId();
        try {
            for (String id : ids) {
                long companyId = GetterUtil.getLong((String)id);
                CompanyThreadLocal.setCompanyId((Long)companyId);
                BatchIndexingActionable batchIndexingActionable = this.getBatchIndexingActionable();
                batchIndexingActionable.setCompanyId(companyId);
                this._modelIndexerWriterContributor.customize(batchIndexingActionable, (ModelIndexerWriterDocumentHelper)new ModelIndexerWriterDocumentHelperImpl(this._modelSearchSettings.getClassName(), this._indexerDocumentBuilder));
                try {
                    batchIndexingActionable.performActions();
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Error reindexing all ", this._modelSearchSettings.getClassName(), " for company: ", companyId}), (Throwable)exception);
                }
            }
        }
        finally {
            CompanyThreadLocal.setCompanyId((Long)companyThreadLocalCompanyId);
        }
    }

    public void reindex(T baseModel) {
        if (!this.isEnabled() || baseModel == null) {
            return;
        }
        IndexerWriterMode indexerWriterMode = this._getIndexerWriterMode(baseModel);
        if (indexerWriterMode == IndexerWriterMode.UPDATE || indexerWriterMode == IndexerWriterMode.PARTIAL_UPDATE) {
            Document document = this._indexerDocumentBuilder.getDocument(baseModel);
            this._updateDocumentIndexWriter.updateDocument(this._modelIndexerWriterContributor.getCompanyId(baseModel), document);
        } else if (indexerWriterMode == IndexerWriterMode.DELETE) {
            this.delete(baseModel);
        } else if (indexerWriterMode == IndexerWriterMode.SKIP && _log.isDebugEnabled()) {
            _log.debug((Object)("Skipping model " + baseModel));
        }
        this._modelIndexerWriterContributor.modelIndexed(baseModel);
    }

    public void setEnabled(boolean enabled) {
        this._indexerEnabled = enabled;
    }

    public void updatePermissionFields(T baseModel) {
        this._searchPermissionIndexWriter.updatePermissionFields(baseModel, this._modelIndexerWriterContributor.getCompanyId(baseModel), this._modelSearchSettings.isCommitImmediately());
    }

    private IndexerWriterMode _getIndexerWriterMode(T baseModel) {
        IndexerWriterMode indexerWriterMode = this._modelIndexerWriterContributor.getIndexerWriterMode(baseModel);
        if (indexerWriterMode != null) {
            return indexerWriterMode;
        }
        if (baseModel instanceof TrashedModel && baseModel instanceof WorkflowedModel) {
            TrashedModel trashedModel = (TrashedModel)baseModel;
            WorkflowedModel workflowedModel = (WorkflowedModel)baseModel;
            if (!workflowedModel.isApproved() && !trashedModel.isInTrash()) {
                return IndexerWriterMode.SKIP;
            }
        }
        return IndexerWriterMode.UPDATE;
    }
}

