/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.indexer;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.ParseException;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.RelatedEntryIndexer;
import com.liferay.portal.kernel.search.RelatedEntryIndexerRegistry;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.indexer.IndexerQueryBuilder;
import com.liferay.portal.search.internal.expando.helper.ExpandoQueryContributorHelper;
import com.liferay.portal.search.internal.indexer.IndexerPostProcessorsHolder;
import com.liferay.portal.search.internal.indexer.IndexerProvidedClausesUtil;
import com.liferay.portal.search.internal.indexer.ModelKeywordQueryContributorsRegistry;
import com.liferay.portal.search.internal.indexer.helper.AddSearchKeywordsQueryContributorHelper;
import com.liferay.portal.search.internal.indexer.helper.PreFilterContributorHelper;
import com.liferay.portal.search.internal.util.SearchStringUtil;
import com.liferay.portal.search.spi.model.query.contributor.KeywordQueryContributor;
import com.liferay.portal.search.spi.model.query.contributor.SearchContextContributor;
import com.liferay.portal.search.spi.model.query.contributor.helper.KeywordQueryContributorHelper;
import com.liferay.portal.search.spi.model.query.contributor.helper.SearchContextContributorHelper;
import com.liferay.portal.search.spi.model.registrar.ModelSearchSettings;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public class IndexerQueryBuilderImpl<T extends BaseModel<?>>
implements IndexerQueryBuilder {
    private final AddSearchKeywordsQueryContributorHelper _addSearchKeywordsQueryContributorHelper;
    private final ExpandoQueryContributorHelper _expandoQueryContributorHelper;
    private final IndexerPostProcessorsHolder _indexerPostProcessorsHolder;
    private final IndexerRegistry _indexerRegistry;
    private final ModelKeywordQueryContributorsRegistry _modelKeywordQueryContributorsRegistry;
    private final Iterable<SearchContextContributor> _modelSearchContextContributors;
    private final ModelSearchSettings _modelSearchSettings;
    private final PreFilterContributorHelper _preFilterContributorHelper;
    private final RelatedEntryIndexerRegistry _relatedEntryIndexerRegistry;
    private final Iterable<SearchContextContributor> _searchContextContributors;

    public IndexerQueryBuilderImpl(AddSearchKeywordsQueryContributorHelper addSearchKeywordsQueryContributorHelper, ExpandoQueryContributorHelper expandoQueryContributorHelper, IndexerRegistry indexerRegistry, ModelSearchSettings modelSearchSettings, ModelKeywordQueryContributorsRegistry modelKeywordQueryContributorsRegistry, Iterable<SearchContextContributor> modelSearchContextContributors, PreFilterContributorHelper preFilterContributorHelper, Iterable<SearchContextContributor> searchContextContributors, IndexerPostProcessorsHolder indexerPostProcessorsHolder, RelatedEntryIndexerRegistry relatedEntryIndexerRegistry) {
        this._addSearchKeywordsQueryContributorHelper = addSearchKeywordsQueryContributorHelper;
        this._expandoQueryContributorHelper = expandoQueryContributorHelper;
        this._indexerRegistry = indexerRegistry;
        this._modelSearchSettings = modelSearchSettings;
        this._modelKeywordQueryContributorsRegistry = modelKeywordQueryContributorsRegistry;
        this._modelSearchContextContributors = modelSearchContextContributors;
        this._preFilterContributorHelper = preFilterContributorHelper;
        this._searchContextContributors = searchContextContributors;
        this._indexerPostProcessorsHolder = indexerPostProcessorsHolder;
        this._relatedEntryIndexerRegistry = relatedEntryIndexerRegistry;
    }

    public BooleanQuery getQuery(SearchContext searchContext) {
        this._resetFullQuery(searchContext);
        Object[] fullQueryEntryClassNames = searchContext.getFullQueryEntryClassNames();
        if (ArrayUtil.isNotEmpty((Object[])fullQueryEntryClassNames)) {
            searchContext.setAttribute("relatedEntryClassNames", (Serializable)this._modelSearchSettings.getSearchClassNames());
        }
        String[] entryClassNames = (String[])ArrayUtil.append((Object[])this._modelSearchSettings.getSearchClassNames(), (Object[])fullQueryEntryClassNames);
        searchContext.setEntryClassNames(entryClassNames);
        this._contributeSearchContext(searchContext);
        Map<String, Indexer<?>> entryClassNameIndexerMap = this._getEntryClassNameIndexerMap(entryClassNames);
        BooleanFilter booleanFilter = new BooleanFilter();
        this._addPreFilters(booleanFilter, entryClassNameIndexerMap, searchContext);
        BooleanQuery fullQuery = this._createFullQuery(booleanFilter, searchContext);
        fullQuery.setQueryConfig(searchContext.getQueryConfig());
        return fullQuery;
    }

    protected void addPreFiltersFromModel(BooleanFilter booleanFilter, ModelSearchSettings modelSearchSettings, SearchContext searchContext) {
        this._preFilterContributorHelper.contribute(booleanFilter, modelSearchSettings, searchContext);
    }

    protected void addSearchTermsFromModel(BooleanQuery booleanQuery, SearchContext searchContext) {
        if (IndexerProvidedClausesUtil.shouldSuppress(searchContext)) {
            return;
        }
        this.contribute(this._modelKeywordQueryContributorsRegistry.stream(this._getStrings("search.full.query.clause.contributors.excludes", searchContext), this._getStrings("search.full.query.clause.contributors.includes", searchContext)), booleanQuery, searchContext);
    }

    protected void contribute(Stream<KeywordQueryContributor> stream, BooleanQuery booleanQuery, final SearchContext searchContext) {
        stream.forEach(keywordQueryContributor -> keywordQueryContributor.contribute(searchContext.getKeywords(), booleanQuery, new KeywordQueryContributorHelper(){

            public String getClassName() {
                return IndexerQueryBuilderImpl.this._modelSearchSettings.getClassName();
            }

            public Stream<String> getSearchClassNamesStream() {
                return Stream.of(IndexerQueryBuilderImpl.this._modelSearchSettings.getSearchClassNames());
            }

            public SearchContext getSearchContext() {
                return searchContext;
            }
        }));
    }

    private void _add(BooleanQuery booleanQuery, Query query, BooleanClauseOccur booleanClauseOccur) {
        try {
            booleanQuery.add(query, booleanClauseOccur);
        }
        catch (ParseException parseException) {
            throw new SystemException((Throwable)parseException);
        }
    }

    private void _addPreFilters(BooleanFilter queryBooleanFilter, Map<String, Indexer<?>> entryClassNameIndexerMap, SearchContext searchContext) {
        this._preFilterContributorHelper.contribute(queryBooleanFilter, entryClassNameIndexerMap, searchContext);
    }

    private void _addSearchExpando(BooleanQuery booleanQuery, Collection<String> searchClassNames, SearchContext searchContext) {
        this._expandoQueryContributorHelper.contribute(StringUtil.trim((String)searchContext.getKeywords()), booleanQuery, searchClassNames, searchContext);
    }

    private void _addSearchKeywords(BooleanQuery booleanQuery, Collection<String> searchClassNames, SearchContext searchContext) {
        this._addSearchKeywordsQueryContributorHelper.contribute(booleanQuery, searchContext);
        this._addSearchExpando(booleanQuery, searchClassNames, searchContext);
    }

    private void _addSearchTermsFromIndexerPostProcessors(BooleanQuery booleanQuery, BooleanFilter booleanFilter, SearchContext searchContext) {
        this._indexerPostProcessorsHolder.forEach(indexerPostProcessor -> {
            try {
                indexerPostProcessor.postProcessSearchQuery(booleanQuery, booleanFilter, searchContext);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new SystemException((Throwable)exception);
            }
        });
    }

    private void _contributeSearchContext(SearchContext searchContext) {
        SearchContextContributorHelper searchContextContributorHelper = () -> this._modelSearchSettings.getSearchClassNames();
        this._searchContextContributors.forEach(searchContextContributor -> searchContextContributor.contribute(searchContext, searchContextContributorHelper));
        this._modelSearchContextContributors.forEach(modelSearchContextContributor -> modelSearchContextContributor.contribute(searchContext, searchContextContributorHelper));
    }

    private BooleanQuery _createFullQuery(BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) {
        BooleanClause[] booleanClauses;
        BooleanQuery keywordBooleanQuery;
        BooleanQueryImpl booleanQuery = new BooleanQueryImpl();
        if (fullQueryBooleanFilter.hasClauses()) {
            booleanQuery.setPreBooleanFilter(fullQueryBooleanFilter);
        }
        if ((keywordBooleanQuery = this._createKeywordQuery(fullQueryBooleanFilter, searchContext)).hasClauses()) {
            this._add((BooleanQuery)booleanQuery, (Query)keywordBooleanQuery, BooleanClauseOccur.MUST);
        }
        if ((booleanClauses = searchContext.getBooleanClauses()) != null) {
            for (BooleanClause booleanClause : booleanClauses) {
                this._add((BooleanQuery)booleanQuery, (Query)booleanClause.getClause(), booleanClause.getBooleanClauseOccur());
            }
        }
        this._postProcessFullQuery((BooleanQuery)booleanQuery, searchContext);
        return booleanQuery;
    }

    private BooleanQuery _createKeywordQuery(BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) {
        BooleanQueryImpl booleanQuery = new BooleanQueryImpl();
        this._addSearchKeywords((BooleanQuery)booleanQuery, Arrays.asList(this._modelSearchSettings.getSearchClassNames()), searchContext);
        this.addSearchTermsFromModel((BooleanQuery)booleanQuery, searchContext);
        this._addSearchTermsFromIndexerPostProcessors((BooleanQuery)booleanQuery, fullQueryBooleanFilter, searchContext);
        return booleanQuery;
    }

    private Map<String, Indexer<?>> _getEntryClassNameIndexerMap(String[] entryClassNames) {
        LinkedHashMap entryClassNameIndexerMap = new LinkedHashMap();
        for (String entryClassName : entryClassNames) {
            Indexer indexer = this._indexerRegistry.getIndexer(entryClassName);
            if (indexer == null) continue;
            entryClassNameIndexerMap.put(entryClassName, indexer);
        }
        return entryClassNameIndexerMap;
    }

    private Collection<String> _getStrings(String string, SearchContext searchContext) {
        return Arrays.asList(SearchStringUtil.splitAndUnquote(Optional.ofNullable((String)((Object)searchContext.getAttribute(string)))));
    }

    private void _postProcessFullQuery(BooleanQuery booleanQuery, SearchContext searchContext) {
        this._indexerPostProcessorsHolder.forEach(indexerPostProcessor -> {
            try {
                indexerPostProcessor.postProcessFullQuery(booleanQuery, searchContext);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new SystemException((Throwable)exception);
            }
        });
    }

    private void _resetFullQuery(SearchContext searchContext) {
        searchContext.clearFullQueryEntryClassNames();
        for (RelatedEntryIndexer relatedEntryIndexer : this._relatedEntryIndexerRegistry.getRelatedEntryIndexers()) {
            relatedEntryIndexer.updateFullQuery(searchContext);
        }
    }
}

