/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.indexer;

import java.util.Collection;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class IncludeExcludeUtil {
    public static <T> Stream<T> stream(Stream<T> stream, Collection<String> includeIds, Collection<String> excludeIds, Function<T, String> function) {
        return IncludeExcludeUtil._exclude(IncludeExcludeUtil._include(stream, includeIds, function), excludeIds, function);
    }

    protected static <T> boolean isPresent(T t, Collection<String> ids, Function<T, String> function) {
        return ids.contains(function.apply(t));
    }

    private static <T> Stream<T> _exclude(Stream<T> stream, Collection<String> ids, Function<T, String> function) {
        return IncludeExcludeUtil._filter(stream, ids, t -> !IncludeExcludeUtil.isPresent(t, ids, function));
    }

    private static <T> Stream<T> _filter(Stream<T> stream, Collection<String> ids, Predicate<? super T> predicate) {
        if (ids == null || ids.isEmpty()) {
            return stream;
        }
        return stream.filter(predicate);
    }

    private static <T> Stream<T> _include(Stream<T> stream, Collection<String> ids, Function<T, String> function) {
        return IncludeExcludeUtil._filter(stream, ids, t -> IncludeExcludeUtil.isPresent(t, ids, function));
    }
}

