/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.indexer;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.PersistedModelLocalServiceRegistry;
import com.liferay.portal.search.indexer.BaseModelRetriever;
import java.io.Serializable;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={BaseModelRetriever.class})
public class BaseModelRetrieverImpl
implements BaseModelRetriever {
    private static final Log _log = LogFactoryUtil.getLog(BaseModelRetrieverImpl.class);
    @Reference
    private PersistedModelLocalServiceRegistry _persistedModelLocalServiceRegistry;

    public Optional<BaseModel<?>> fetchBaseModel(String className, long classPK) {
        PersistedModel persistModel = this._getPersistedModel(className, classPK);
        if (persistModel == null) {
            return Optional.empty();
        }
        if (!(persistModel instanceof BaseModel)) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)(persistModel + " is not a base model"));
            }
            return Optional.empty();
        }
        return Optional.ofNullable((BaseModel)persistModel);
    }

    private PersistedModel _getPersistedModel(String className, long classPK) {
        PersistedModelLocalService persistedModelLocalService = this._getPersistedModelLocalService(className);
        try {
            return persistedModelLocalService.getPersistedModel((Serializable)Long.valueOf(classPK));
        }
        catch (PortalException portalException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{"No ", className, " found for class PK ", classPK}), (Throwable)portalException);
            }
            return null;
        }
    }

    private PersistedModelLocalService _getPersistedModelLocalService(String className) {
        PersistedModelLocalService persistedModelLocalService = this._persistedModelLocalServiceRegistry.getPersistedModelLocalService(className);
        if (persistedModelLocalService == null) {
            throw new SystemException("No persisted model local service found for class " + className);
        }
        return persistedModelLocalService;
    }
}

