/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.indexer;

import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ResourcedModel;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.search.document.DocumentBuilder;
import com.liferay.portal.search.document.DocumentBuilderFactory;
import com.liferay.portal.search.indexer.BaseModelDocumentFactory;
import com.liferay.portal.search.model.uid.UIDFactory;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={BaseModelDocumentFactory.class})
public class BaseModelDocumentFactoryImpl
implements BaseModelDocumentFactory {
    @Reference
    protected DocumentBuilderFactory documentBuilderFactory;
    @Reference
    protected UIDFactory uidFactory;

    public Document createDocument(BaseModel<?> baseModel) {
        DocumentBuilder documentBuilder = this.documentBuilderFactory.builder();
        Tuple classPKResourcePrimKeyTuple = this._getClassPKResourcePrimKey(baseModel);
        documentBuilder.setString("entryClassName", baseModel.getModelClassName()).setLong("entryClassPK", (Long)classPKResourcePrimKeyTuple.getObject(0)).setLong("rootEntryClassPK", this._getRootEntryClassPK(classPKResourcePrimKeyTuple));
        this.uidFactory.setUID(baseModel, documentBuilder);
        com.liferay.portal.search.document.Document document = documentBuilder.build();
        this._enforceStandardUID(document);
        return this._toLegacyDocument(document);
    }

    private void _enforceStandardUID(com.liferay.portal.search.document.Document document) {
        this.uidFactory.getUID(document);
    }

    private Tuple _getClassPKResourcePrimKey(BaseModel<?> baseModel) {
        long classPK = 0L;
        long resourcePrimKey = 0L;
        if (baseModel instanceof ResourcedModel) {
            ResourcedModel resourcedModel = (ResourcedModel)baseModel;
            classPK = resourcedModel.getResourcePrimKey();
            resourcePrimKey = resourcedModel.getResourcePrimKey();
        } else {
            classPK = (Long)baseModel.getPrimaryKeyObj();
        }
        return new Tuple(new Object[]{classPK, resourcePrimKey});
    }

    private Long _getRootEntryClassPK(Tuple classPKResourcePrimKeyTuple) {
        long resourcePrimKey = (Long)classPKResourcePrimKeyTuple.getObject(1);
        if (resourcePrimKey > 0L) {
            return resourcePrimKey;
        }
        return null;
    }

    private Document _toLegacyDocument(com.liferay.portal.search.document.Document document) {
        DocumentImpl documentImpl = new DocumentImpl();
        Map fields = document.getFields();
        fields.forEach((key, field) -> documentImpl.add(new Field(key, String.valueOf(field.getValue()))));
        return documentImpl;
    }
}

