/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.index;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.events.StartupHelperUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.IndexStatusManagerThreadLocal;
import com.liferay.portal.search.configuration.IndexStatusManagerConfiguration;
import com.liferay.portal.search.index.IndexStatusManager;
import com.liferay.portal.search.internal.index.configuration.IndexStatusManagerInternalConfiguration;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"com.liferay.portal.search.configuration.IndexStatusManagerConfiguration", "com.liferay.portal.search.internal.index.configuration.IndexStatusManagerInternalConfiguration"}, immediate=true, service={IndexStatusManager.class})
public class IndexStatusManagerImpl
implements IndexStatusManager {
    private static final Log _log = LogFactoryUtil.getLog(IndexStatusManagerImpl.class);
    private volatile boolean _indexReadOnly;
    private Throwable _indexReadOnlyCallStackThrowable;
    private final Set<String> _indexReadOnlyModels = Collections.newSetFromMap(new ConcurrentHashMap());
    private boolean _readWriteRequired;
    private Throwable _requireIndexReadWriteCallStackThrowable;
    private volatile boolean _suppressIndexReadOnly;

    public boolean isIndexReadOnly() {
        if (this._suppressIndexReadOnly) {
            return false;
        }
        return IndexStatusManagerThreadLocal.isIndexReadOnly() || this._indexReadOnly || StartupHelperUtil.isUpgrading();
    }

    public boolean isIndexReadOnly(String className) {
        return this._indexReadOnlyModels.contains(className);
    }

    public void requireIndexReadWrite(boolean required) {
        if (required) {
            if (this._indexReadOnly) {
                if (_log.isWarnEnabled()) {
                    _log.warn(new Throwable(StringBundler.concat((String[])new String[]{"Setting index to Read-Write as required by ", "incoming operation, overriding currently set ", "Read-Only (see exception for Read-Write call ", "stack and nested exception for Read-Only ", "call stack)"}), this._indexReadOnlyCallStackThrowable));
                }
                this._indexReadOnly = false;
            }
            this._requireIndexReadWriteCallStackThrowable = new Throwable();
        }
        this._readWriteRequired = required;
    }

    public void setIndexReadOnly(boolean indexReadOnly) {
        if (indexReadOnly) {
            if (this._readWriteRequired) {
                if (_log.isWarnEnabled()) {
                    _log.warn(new Throwable(StringBundler.concat((String[])new String[]{"Suppressing attempt to set index to ", "Read-Only while ongoing operation requires ", "Read-Write (see exception for Read-Only call ", "stack and nested exception for Read-Write ", "call stack)"}), this._requireIndexReadWriteCallStackThrowable));
                }
                return;
            }
            this._indexReadOnlyCallStackThrowable = new Throwable();
        }
        this._indexReadOnly = indexReadOnly;
    }

    public void setIndexReadOnly(String className, boolean indexReadOnly) {
        if (indexReadOnly) {
            this._indexReadOnlyModels.add(className);
        } else {
            this._indexReadOnlyModels.remove(className);
        }
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        IndexStatusManagerConfiguration indexStatusManagerConfiguration = (IndexStatusManagerConfiguration)ConfigurableUtil.createConfigurable(IndexStatusManagerConfiguration.class, properties);
        this._indexReadOnly = indexStatusManagerConfiguration.indexReadOnly();
        IndexStatusManagerInternalConfiguration indexStatusManagerInternalConfiguration = (IndexStatusManagerInternalConfiguration)ConfigurableUtil.createConfigurable(IndexStatusManagerInternalConfiguration.class, properties);
        this._suppressIndexReadOnly = indexStatusManagerInternalConfiguration.suppressIndexReadOnly();
    }
}

