/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.hits;

import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.highlight.HighlightField;
import com.liferay.portal.search.hits.SearchHit;
import com.liferay.portal.search.hits.SearchHitBuilder;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SearchHitImpl
implements SearchHit,
Serializable {
    private Document _document;
    private String _explanation;
    private final Map<String, HighlightField> _highlightFieldsMap = new LinkedHashMap<String, HighlightField>();
    private String _id;
    private String[] _matchedQueries = new String[0];
    private float _score;
    private final Map<String, Object> _sourcesMap = new LinkedHashMap<String, Object>();
    private long _version;

    public void addHighlightFields(Collection<HighlightField> highlightFields) {
        highlightFields.forEach(this::addHighlightField);
    }

    public void addSources(Map<String, Object> sourcesMap) {
        if (MapUtil.isNotEmpty(sourcesMap)) {
            this._sourcesMap.putAll(sourcesMap);
        }
    }

    public Document getDocument() {
        return this._document;
    }

    public String getExplanation() {
        return this._explanation;
    }

    public Map<String, HighlightField> getHighlightFieldsMap() {
        return this._highlightFieldsMap;
    }

    public String getId() {
        return this._id;
    }

    public String[] getMatchedQueries() {
        return this._matchedQueries;
    }

    public float getScore() {
        return this._score;
    }

    public Map<String, Object> getSourcesMap() {
        return this._sourcesMap;
    }

    public long getVersion() {
        return this._version;
    }

    protected SearchHitImpl(SearchHitImpl searchHitImpl) {
        this._document = searchHitImpl._document;
        this._explanation = searchHitImpl._explanation;
        this._id = searchHitImpl._id;
        this._matchedQueries = searchHitImpl._matchedQueries;
        this._score = searchHitImpl._score;
        this._version = searchHitImpl._version;
        this._highlightFieldsMap.putAll(searchHitImpl._highlightFieldsMap);
        this._sourcesMap.putAll(searchHitImpl._sourcesMap);
    }

    protected void addHighlightField(HighlightField highlightField) {
        this._highlightFieldsMap.put(highlightField.getName(), highlightField);
    }

    protected void addSource(String name, Object value) {
        this._sourcesMap.put(name, value);
    }

    private SearchHitImpl() {
    }

    private void _setDocument(Document document) {
        this._document = document;
    }

    private void _setExplanation(String explanation) {
        this._explanation = explanation;
    }

    private void _setId(String id) {
        this._id = id;
    }

    private void _setMatchedQueries(String ... matchedQueries) {
        this._matchedQueries = matchedQueries != null ? matchedQueries : new String[0];
    }

    private void _setScore(float score) {
        this._score = score;
    }

    private void _setVersion(long version) {
        this._version = version;
    }

    protected static class Builder
    implements SearchHitBuilder {
        private final SearchHitImpl _searchHitImpl = new SearchHitImpl();

        protected Builder() {
        }

        public SearchHitBuilder addHighlightField(HighlightField highlightField) {
            this._searchHitImpl.addHighlightField(highlightField);
            return this;
        }

        public SearchHitBuilder addHighlightFields(Collection<HighlightField> highlightFields) {
            this._searchHitImpl.addHighlightFields(highlightFields);
            return this;
        }

        @Deprecated
        public SearchHitBuilder addHighlightFields(Stream<HighlightField> highlightFieldStream) {
            this._searchHitImpl.addHighlightFields(highlightFieldStream.collect(Collectors.toList()));
            return this;
        }

        public SearchHitBuilder addSource(String name, Object value) {
            this._searchHitImpl.addSource(name, value);
            return this;
        }

        public SearchHitBuilder addSources(Map<String, Object> sourcesMap) {
            this._searchHitImpl.addSources(sourcesMap);
            return this;
        }

        public SearchHit build() {
            return new SearchHitImpl(this._searchHitImpl);
        }

        public SearchHitBuilder document(Document document) {
            this._searchHitImpl._setDocument(document);
            return this;
        }

        public SearchHitBuilder explanation(String explanation) {
            this._searchHitImpl._setExplanation(explanation);
            return this;
        }

        public SearchHitBuilder id(String id) {
            this._searchHitImpl._setId(id);
            return this;
        }

        public SearchHitBuilder matchedQueries(String ... matchedQueries) {
            this._searchHitImpl._setMatchedQueries(matchedQueries);
            return this;
        }

        public SearchHitBuilder score(float score) {
            this._searchHitImpl._setScore(score);
            return this;
        }

        public SearchHitBuilder version(long version) {
            this._searchHitImpl._setVersion(version);
            return this;
        }
    }
}

